/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import ccl.swing.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ComponentHierachyFrame
extends JFrame {
    private JButton _btnUpdate = new JButton("Update");
    private JButton _btnClose = new JButton("Close");
    private JTree _pTree = null;
    private UpdateThread _pThread = null;

    private DefaultMutableTreeNode _add(DefaultTreeModel pDefaultTreeModel_, DefaultMutableTreeNode tnParent_, Component pComponent_, int index_) {
        DefaultMutableTreeNode tnComponent;
        block3: {
            block2: {
                tnComponent = new DefaultMutableTreeNode(pComponent_.toString());
                pDefaultTreeModel_.insertNodeInto(tnComponent, tnParent_, index_);
                TreePath pTreePath = new TreePath(pDefaultTreeModel_.getPathToRoot(tnComponent));
                this._pTree.expandPath(pTreePath);
                if (!(pComponent_ instanceof MenuElement)) break block2;
                MenuElement[] apMenuElement = ((MenuElement)((Object)pComponent_)).getSubElements();
                int child = 0;
                while (child < apMenuElement.length) {
                    this._add(pDefaultTreeModel_, tnComponent, (Component)((Object)apMenuElement[child]), child);
                    ++child;
                }
                break block3;
            }
            if (!(pComponent_ instanceof Container)) break block3;
            Container pContainer = (Container)pComponent_;
            Component[] apComponent = pContainer.getComponents();
            int child = 0;
            while (child < apComponent.length) {
                this._add(pDefaultTreeModel_, tnComponent, apComponent[child], child);
                ++child;
            }
        }
        return tnComponent;
    }

    private void _update() {
        SwingUtil.invokeLaterIfNecessary(new Runnable(){

            public void run() {
                DefaultMutableTreeNode tnRoot = new DefaultMutableTreeNode("All frames and their owned windows");
                DefaultTreeModel pDefaultTreeModel = new DefaultTreeModel(tnRoot);
                ComponentHierachyFrame.this._pTree.setModel(pDefaultTreeModel);
                Frame[] apFrame = Frame.getFrames();
                int index = 0;
                int frame = 0;
                while (frame < apFrame.length) {
                    Frame frmNext = apFrame[frame];
                    if (frmNext != ComponentHierachyFrame.this) {
                        ComponentHierachyFrame.this._add(pDefaultTreeModel, tnRoot, frmNext, index);
                        ++index;
                        Window[] apWindow = frmNext.getOwnedWindows();
                        int window = 0;
                        while (window < apWindow.length) {
                            ComponentHierachyFrame.this._add(pDefaultTreeModel, tnRoot, apWindow[window], index);
                            ++index;
                            ++window;
                        }
                    }
                    ++frame;
                }
            }
        });
    }

    public ComponentHierachyFrame() {
        super("Component Hierachy Viewer");
        this._btnUpdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent pActionEvent_) {
                ComponentHierachyFrame.this._update();
            }
        });
        this._btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent pActionEvent_) {
                ComponentHierachyFrame.this.dispose();
            }
        });
        DefaultMutableTreeNode tnRoot = new DefaultMutableTreeNode("JFrame");
        DefaultTreeModel pDefaultTreeModel = new DefaultTreeModel(tnRoot);
        this._pTree = new JTree(pDefaultTreeModel);
        JScrollPane pScrollPane = new JScrollPane(this._pTree);
        pScrollPane.setBorder(SwingUtil.createCCLBorder());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._btnUpdate, "North");
        this.getContentPane().add((Component)pScrollPane, "Center");
        this.getContentPane().add((Component)this._btnClose, "South");
        SwingUtil.maximizeWindow(this);
    }

    public void setVisible(boolean bVisible_) {
        if (bVisible_) {
            this._pThread = new UpdateThread();
        } else if (this._pThread != null) {
            this._pThread.stopIt();
            try {
                this._pThread.join();
            }
            catch (Exception pException) {
                // empty catch block
            }
        }
        super.setVisible(bVisible_);
    }

    private class UpdateThread
    extends Thread {
        private boolean _bStop = false;

        public void run() {
            while (!this._bStop) {
                try {
                    Thread.sleep(10000L);
                    ComponentHierachyFrame.this._update();
                }
                catch (Exception pException) {
                    // empty catch block
                }
            }
        }

        public void stopIt() {
            this._bStop = true;
            this.interrupt();
        }
    }
}

