/*
 * Decompiled with CFR 0.152.
 */
package ccl.util.test;

import ccl.util.FileUtil;
import ccl.util.Init;
import ccl.util.Test;
import ccl.util.Util;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;

public class UtilTest
extends Test {
    private Init _init = null;

    private void _checkFormatCenter() {
        this._enterSubTest("text center formatting");
        String sInput = "hallo";
        String sExpectedResult = "hallo\n";
        int lineLength = 3;
        this.Assert(Util.formatCenter(sInput, lineLength).equals(sExpectedResult), "Formatting should be '" + sExpectedResult + "' but is: '" + Util.formatCenter(sInput, lineLength) + "'");
        sExpectedResult = " hallo\n";
        lineLength = 7;
        this.Assert(Util.centerLine(sInput, lineLength).equals(sExpectedResult.substring(0, sExpectedResult.length() - 1)), "Formatting should be '" + sExpectedResult + "' but is: '" + Util.formatCenter(sInput, lineLength) + "'");
        this.Assert(Util.formatCenter(sInput, lineLength).equals(sExpectedResult));
        sExpectedResult = " hallo\n";
        lineLength = 8;
        this.Assert(Util.formatCenter(sInput, lineLength).equals(sExpectedResult));
        sExpectedResult = "hallo\n";
        lineLength = 6;
        this.Assert(Util.formatCenter(sInput, lineLength).equals(sExpectedResult));
        sInput = "hal  lo";
        sExpectedResult = "hal lo\n";
        lineLength = 7;
        this.Assert(Util.formatCenter(sInput, lineLength).equals(sExpectedResult));
        this._exitSubTest();
    }

    private void _checkFormatBlock() {
        this._enterSubTest("text block formatting");
        String sInput = "hallo";
        String sExpectedResult = "hallo\n";
        this.Assert(Util.formatBlock(sInput).equals(sExpectedResult));
        int lineLength = 20;
        sInput = "1234 6789 1234 6789 1234 6789";
        sExpectedResult = "1234 6789 1234 6789\n1234 6789\n";
        String sResult = Util.formatLeft(sInput, lineLength);
        this.Assert(Util.formatLeft(sInput, lineLength).equals(sExpectedResult), "Result: '" + sResult + "'");
        sInput = "1234 6789 1234 6789_ 1234 6789";
        sExpectedResult = "1234 6789 1234 6789_\n1234 6789\n";
        sResult = Util.formatLeft(sInput, lineLength);
        this.Assert(Util.formatLeft(sInput, lineLength).equals(sExpectedResult), "Result: '" + sResult + "'");
        sInput = "1234 6789 1234 6789_1234 6789 67890";
        sExpectedResult = "1234 6789 1234\n6789_1234 6789 67890\n";
        sResult = Util.formatLeft(sInput, lineLength);
        this.Assert(Util.formatLeft(sInput, lineLength).equals(sExpectedResult), "Result: '" + sResult + "'");
        sInput = "1234 6789 1234 6789_1234 6789 67890_";
        sExpectedResult = "1234 6789 1234\n6789_1234 6789\n67890_\n";
        sResult = Util.formatLeft(sInput, lineLength);
        this.Assert(Util.formatLeft(sInput, lineLength).equals(sExpectedResult), "Result: '" + sResult + "'");
        sInput = "";
        sExpectedResult = "\n";
        sResult = Util.formatLeft(sInput, lineLength);
        this.Assert(Util.formatLeft(sInput, lineLength).equals(sExpectedResult), "Result: '" + sResult + "'");
        lineLength = 72;
        sInput = "Contract work as a Java programmer in Zurich or tele-commuting via Internet.";
        sExpectedResult = "Contract work as a Java  programmer  in  Zurich  or  tele-commuting  via\nInternet.\n";
        sResult = Util.formatBlock(sInput, lineLength);
        this.Assert(Util.formatBlock(sInput, lineLength).equals(sExpectedResult), "Result: '" + sResult + "'");
        lineLength = 64;
        sInput = "I  am  familiar  with  object  oriented  methodologies  (Coad,\nJacobson, Rumbaugh, Booch, UML) and tools (Rational Rose).";
        sExpectedResult = "I  am  familiar  with  object  oriented   methodologies   (Coad,\nJacobson, Rumbaugh, Booch, UML) and tools (Rational Rose).\n";
        sResult = Util.formatBlock(sInput, lineLength);
        this.Assert(Util.formatBlock(sInput, lineLength).equals(sExpectedResult), "Result: '" + sResult + "'");
        this._exitSubTest();
    }

    public UtilTest() {
    }

    public UtilTest(Test pTest_) {
        super(pTest_);
    }

    protected void _doIt() throws Exception {
        String sLocalPath = FileUtil.getClassPath(this);
        this.testGetNextDay();
        this.testGetDiffPosition();
        this._checkFormatCenter();
        this._checkFormatBlock();
        boolean bRndBug = false;
        int anz = 0;
        while (anz < 100) {
            float fR = Util.rnd(5.0f);
            if ((double)fR <= 0.0 || 5.0 <= (double)fR) {
                bRndBug = true;
            }
            ++anz;
        }
        this.bugIf(bRndBug, "Fehler in Util.fRnd");
        bRndBug = false;
        int anz2 = 0;
        while (anz2 < 100) {
            float fR = Util.rnd(5.0f);
            if ((double)fR <= 0.0 || 5.0 <= (double)fR) {
                bRndBug = true;
            }
            ++anz2;
        }
        this.bugIf(bRndBug, "Fehler in Util.fRnd double");
        this.bugIf(!Util.firstCharToUpperCase("jamacs").equals("Jamacs"));
        this.bugIf(!Util.firstCharToUpperCase("Jamacs").equals("Jamacs"));
        this.bugIf(!Util.firstCharToUpperCase(null).equals(""));
        this.bugIf(!Util.firstCharToUpperCase(new String()).equals(""));
        this.bugIf(!Util.firstCharToUpperCase(new String()).equals(new String()));
        this.bugIf(!Util.firstCharToUpperCase("++*").equals("++*"));
        boolean bZero = false;
        boolean bOne = false;
        int i = 0;
        while (i < 20) {
            int r = Util.rnd(1);
            if (r == 1) {
                bOne = true;
            } else if (r == 0) {
                bZero = true;
            } else {
                this.bugIf(true, "Andere Zahl als 0 oder 1");
            }
            ++i;
        }
        this.bugIf(!bZero || !bOne);
        String sTest31 = "eh Allo\t du Arsch!\t\tWie geht's?\n";
        String sErg31 = Util.replace(sTest31, "\t", "   ");
        this.bugIf(!sErg31.equals("eh Allo    du Arsch!      Wie geht's?\n"), sErg31);
        sErg31 = Util.replace(sTest31, "eh", "boh");
        this.bugIf(!sErg31.equals("boh Allo\t du Arsch!\t\tWie gboht's?\n"));
        String o = new String("Hello World!");
        Util.debug("Test: Nr. 33: o.getClassName: " + o.getClass().getName());
        this.bugIf(!o.getClass().getName().equals("java.lang.String"));
        String sTest18 = "-g   -deprecation";
        sTest18 = Util.replace(sTest18, "  ", " ");
        this.bugIf(!sTest18.equals("-g  -deprecation"));
        String sReplaceString = "/home/clemens/bunin/jacob/RCS/Jacob.java";
        String sReplaceResult = "\\home\\clemens\\bunin\\jacob\\RCS\\Jacob.java";
        this.bugIf(!Util.replace(sReplaceString, "/", "\\").equals(sReplaceResult));
        InputStream inputStream = FileUtil.getResourceAsStream(this, "sWindowsMakefile.txt");
        sReplaceString = FileUtil.readStream(inputStream);
        sReplaceResult = Util.replace(sReplaceString, "/", "\\");
        this.bugIf(sReplaceString.equals(sReplaceResult));
        this.bugIf(sReplaceString.length() != sReplaceResult.length());
        this._checkAtoi();
        this._checkIntAndBytes();
        this._checkDateMethods();
        this.bugIf(!Util.isDigit('0'));
        this.bugIf(!Util.isDigit('1'));
        this.bugIf(!Util.isDigit('8'));
        this.bugIf(!Util.isDigit('9'));
        this.bugIf(Util.isDigit('O'));
        this.bugIf(Util.isDigit('A'));
        this._checkDateValidation();
        this.bugIf(Util.rightPaddWithSpace("123", 12).equals("123000000000"));
        this.bugIf(!Util.rightPaddWithSpace("123", 12).equals("123         "));
        this._checkNumberOfDays();
        String sShrinked = Util.shrinkString("/home/clemens/src/java/ccl/src/ccl/util/test/UtilTest.java", 20);
        this.Assert(sShrinked.equals("/home/cl[...]st.java"), sShrinked);
        sShrinked = Util.shrinkString("/home/clemens/src/java/ccl/src/ccl/util/test/UtilTest.java", 21);
        this.Assert(sShrinked.equals("/home/cl[...]est.java"), sShrinked);
        sShrinked = Util.shrinkString("/home/clemens/src/java/ccl/src/ccl/util/test/UtilTest.java", 19);
        this.Assert(sShrinked.equals("/home/c[...]st.java"), sShrinked);
    }

    private void _checkAtoi() {
        this._enterSubTest("atoi");
        this.bugIf(Util.atoi(null) != 0);
        this.bugIf(Util.atoi("") != 0);
        this.bugIf(Util.atoi(" ") != 0);
        this.bugIf(Util.atoi("-+\u00a7\"\u00a7\u00dc\u00d6$324") != 0);
        this.bugIf(Util.atoi("-1") != -1);
        this.bugIf(Util.atoi("- 1") != 0);
        this.bugIf(Util.atoi("   -27   ") != -27);
        this.bugIf(Util.atoi("   -27343l   ") != -27343);
        this.bugIf(Util.atoi("2147483646") != 0x7FFFFFFE);
        this.bugIf(Util.atoi("2147483647") != Integer.MAX_VALUE);
        this.bugIf(Util.atoi("2147483648") != 0x7FFFFFF8, "" + Util.atoi("2147483648"));
        this.bugIf(Util.atoi("-2147483648") != Integer.MIN_VALUE);
        this.bugIf(Util.atoi("-2147483647") != -2147483647);
        this.bugIf(Util.atoi("-2147483649") != -2147483640, "" + Util.atoi("-2147483649"));
        this.bugIf(Util.atoi("234234wjsldfkj") != 234234);
        this.bugIf(Util.atoi("aaaaasdf34234") != 0);
        this.bugIf(Util.atoi("0x1a") != 0);
        this._exitSubTest();
    }

    private void _checkIntAndBytes() {
        this._enterSubTest("Int/Bytes Conversion");
        byte[] ab = Util.intToBytes(Integer.MAX_VALUE);
        this.bugIf(ab[0] != 127, "1. ab[ 0 ] should be 0x7f but is: " + ab[0]);
        this.bugIf(ab[1] != -1, "1. ab[ 1 ] should be -1 but is: " + ab[1]);
        this.bugIf(ab[2] != -1, "1. ab[ 2 ] should be -1 but is: " + ab[2]);
        this.bugIf(ab[3] != -1, "1. ab[ 3 ] should be -1 but is: " + ab[3]);
        ab = Util.intToBytes(Integer.MIN_VALUE);
        this.bugIf(ab[0] != -128, "2. ab[ 0 ] should be -128 but is: " + ab[0]);
        this.bugIf(ab[1] != 0, "2. ab[ 1 ] should be 0 but is: " + ab[1]);
        this.bugIf(ab[2] != 0, "2. ab[ 2 ] should be 0 but is: " + ab[2]);
        this.bugIf(ab[3] != 0, "2. ab[ 3 ] should be 0 but is: " + ab[3]);
        ab = Util.intToBytes(-2147483647);
        this.bugIf(ab[0] != -128, "3. ab[ 0 ] should be -128 but is: " + ab[0]);
        this.bugIf(ab[1] != 0, "3. ab[ 1 ] should be 0 but is: " + ab[1]);
        this.bugIf(ab[2] != 0, "3. ab[ 2 ] should be 0 but is: " + ab[2]);
        this.bugIf(ab[3] != 1, "3. ab[ 3 ] should be 1 but is: " + ab[3]);
        this.bugIf(false, "Peng!");
        this.bugIf(Util.bytesToInt(ab) != -2147483647);
        ab[0] = -128;
        ab[1] = 0;
        ab[2] = 1;
        ab[3] = 3;
        this.bugIf(Util.bytesToInt(ab) != -2147483389);
        ab = Util.intToBytes(0);
        this.bugIf(ab[0] != 0, "4.");
        this.bugIf(ab[1] != 0, "4.");
        this.bugIf(ab[2] != 0, "4.");
        this.bugIf(ab[3] != 0, "4.");
        ab = Util.intToBytes(1);
        this.bugIf(ab[0] != 0, "5.");
        this.bugIf(ab[1] != 0, "5.");
        this.bugIf(ab[2] != 0, "5.");
        this.bugIf(ab[3] != 1, "5.");
        ab = Util.intToBytes(255);
        this.bugIf(ab[0] != 0, "6. ab[ 0 ]: " + ab[0]);
        this.bugIf(ab[1] != 0, "6.");
        this.bugIf(ab[2] != 0, "6.");
        this.bugIf(ab[3] != -1, "6. ab[ 3 ]: " + ab[3]);
        ab = Util.intToBytes(-1);
        this.bugIf(ab[0] != -1, "7. ab[ 0 ]: " + ab[0]);
        this.bugIf(ab[1] != -1, "7.");
        this.bugIf(ab[2] != -1, "7.");
        this.bugIf(ab[3] != -1, "7. ab[ 3 ]: " + ab[3]);
        ab = Util.intToBytes(16909060);
        this.bugIf(ab[0] != 1, "8. ab[ 0 ] should be 1 but is: " + ab[0]);
        this.bugIf(ab[1] != 2, "8. ab[ 1 ] should be 2 but is: " + ab[1]);
        this.bugIf(ab[2] != 3, "8. ab[ 2 ] should be 3 but is: " + ab[2]);
        this.bugIf(ab[3] != 4, "8. ab[ 3 ] should be 4 but is: " + ab[3]);
        this.bugIf(Util.bytesToInt(Util.intToBytes(-1)) != -1);
        this.bugIf(Util.bytesToInt(Util.intToBytes(-543542453)) != -543542453);
        this._exitSubTest();
    }

    private void _checkDateMethods() {
        Calendar pCalendar = Util.getCalendar();
        String sTestTime = "00:00:00";
        Util.setTime(pCalendar, sTestTime);
        String sResultTime = Util.getTime(pCalendar);
        this.bugIf(!sResultTime.equals(sTestTime), "Time is not " + sTestTime + " but " + sResultTime + "!");
        pCalendar = Util.getCalendar();
        sTestTime = "00:00:01";
        Util.setTime(pCalendar, sTestTime);
        sResultTime = Util.getTime(pCalendar);
        this.bugIf(!sResultTime.equals(sTestTime), "Time is not " + sTestTime + " but " + sResultTime + "!");
        pCalendar = Util.getCalendar();
        sTestTime = "23:59:59";
        Util.setTime(pCalendar, sTestTime);
        sResultTime = Util.getTime(pCalendar);
        this.bugIf(!sResultTime.equals(sTestTime), "Time is not " + sTestTime + " but " + sResultTime + "!");
        pCalendar = Util.getDate("1999-11-20");
        sTestTime = "15:22:38";
        Util.setTime(pCalendar, sTestTime);
        sResultTime = Util.getTime(pCalendar);
        this.bugIf(!sResultTime.equals(sTestTime), "Time is not " + sTestTime + " but " + sResultTime + "!");
        this.bugIf(!Util.getDate(pCalendar).equals("1999-11-20"), "Date changed!");
        long lMillis = pCalendar.getTime().getTime() % 1000L;
        this.bugIf(lMillis != 0L, "Millis are not 0 but " + lMillis);
        pCalendar = Util.getDate("1996-12-09");
        this.bugIf(!Util.getDate(pCalendar).equals("1996-12-09"), "Date conversion bug!");
        this.bugIf(!Util.getLastDayOfMonth("2000-05-01").equals("2000-05-31"));
        this.bugIf(!Util.getLastDayOfMonth("2000-06-03").equals("2000-06-30"));
        this.bugIf(!Util.getLastDayOfMonth("2000-07-06").equals("2000-07-31"));
    }

    private void _checkNumberOfDays() {
        this.bugIf(Util.getNumberOfDays("2000-06-13", "2000-06-14") != 2, "Number of days between 2000-06-13 and 2000-06-14 is falsely " + Util.getNumberOfDays("2000-06-13", "2000-06-14"));
        this.bugIf(Util.getNumberOfDays("2000-01-10", "2000-01-21") != 12, "Number of days between 2000-01-10 and 2000-01-21 is falsely " + Util.getNumberOfDays("2000-01-10", "2000-01-21"));
    }

    private void _checkDateValidation() {
        this._enterSubTest("Date Validation");
        String sDate = "20000525";
        int offset = 1;
        if (sDate.length() == 8) {
            offset = 0;
        }
        this.bugIf(offset != 0, "Assuming wrong date length.");
        Date dtRetVal = new Date();
        try {
            String sYear = sDate.substring(0, 4);
            this.bugIf(!sYear.equals("2000"));
            String sMonth = sDate.substring(4 + offset, 6 + offset);
            this.bugIf(!sMonth.equals("05"));
            String sDay = sDate.substring(6 + 2 * offset, 8 + 2 * offset);
            this.bugIf(!sDay.equals("25"));
            int year = Util.atoi(sYear);
            this.bugIf(year != 2000);
            int month = Util.atoi(sMonth) - 1;
            this.bugIf(month != 4);
            int day = Util.atoi(sDay);
            this.bugIf(day != 25);
            this.bugIf(false);
        }
        catch (Exception pException) {
            this.bugIf(true);
        }
        this.bugIf(!Util.isDateValid("2000-05-25"), "Date 2000-05-25 should be valid but it isn't.");
        this.bugIf(Util.stringToDate("20000525") == null, "Date string \"20000525\" could not be converted to a date.");
        Date dateShort = Util.stringToDate("20000525");
        Date dateNormal = Util.stringToDate("2000-05-25");
        this.bugIf(!Util.getStandardDate(dateShort).equals(Util.getStandardDate(dateNormal)), "Short and normal dates differ!");
        this.bugIf(!Util.getStandardDate(dateShort).equals("2000-05-25"), "Short and normal dates differ!");
        this.bugIf(sDate == null || sDate.length() != 8 && sDate.length() != 10);
        Date pDate = Util.stringToDate(sDate);
        this.bugIf(!Util.getStandardDate(pDate).equals("2000-05-25"));
        Date dtValidation = new Date(pDate.getTime());
        this.bugIf(!Util.getStandardDate(dtValidation).equals("2000-05-25"));
        String sValidation = Util.getStandardDate(dtValidation);
        this.bugIf(!sValidation.equals("2000-05-25"), "sValidation: --->" + sValidation + "<---");
        this.bugIf(!Util.isDateValid("20000525"), "Date 20000525 should be valid but it isn't.");
        this.bugIf(Util.isDateValid("20000231"), "Date 20000231 should not be valid but it is.");
        this._exitSubTest();
    }

    public void testGetDiffPosition() {
        int position;
        this._enterSubTest("getDiffPosition");
        try {
            position = Util.getDiffPosition(null, null);
            this.bugIf(true, "Should not reach this point");
        }
        catch (IllegalArgumentException argumentException) {
            this.Assert(true, "Should reach this point");
        }
        try {
            position = Util.getDiffPosition("something", null);
            this.bugIf(true, "Should not reach this point");
        }
        catch (IllegalArgumentException argumentException) {
            this.Assert(true, "Should reach this point");
        }
        try {
            int position2 = Util.getDiffPosition(null, "happy day");
            this.bugIf(true, "Should not reach this point");
        }
        catch (IllegalArgumentException argumentException) {
            this.Assert(true, "Should reach this point");
        }
        int position3 = Util.getDiffPosition("something", "happy day");
        this.Assert(position3 == 0);
        position3 = Util.getDiffPosition("something", "Shappy day");
        this.Assert(position3 == 0);
        position3 = Util.getDiffPosition("something", "");
        this.Assert(position3 == 0);
        position3 = Util.getDiffPosition("", "Shappy day");
        this.Assert(position3 == 0);
        position3 = Util.getDiffPosition("something", "someShappy day");
        this.Assert(position3 == 4);
        position3 = Util.getDiffPosition("something", "something happy day");
        this.Assert(position3 == 9);
        this._exitSubTest();
    }

    public void testGetNextDay() {
        this.Assert(Util.getNextDay("2002-11-03").equals("2002-11-04"));
        this.Assert(Util.getNextDay("2002-10-30").equals("2002-10-31"));
        this.Assert(Util.getNextDay("2002-10-31").equals("2002-11-01"));
    }

    public void setInit(Init init_) {
        this._init = init_;
    }

    public static void main(String[] args) {
        UtilTest pTest = new UtilTest();
        pTest.setVerbose(true);
        pTest.setTiming(true);
        pTest.run();
        pTest.printResult();
        System.exit(0);
    }
}

