/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log;

import org.objectweb.howl.log.LogException;
import org.objectweb.howl.log.LogRecord;
import org.objectweb.howl.log.Logger;
import org.objectweb.howl.log.ReplayListener;

class TestLogReader
implements ReplayListener {
    LogRecord logrec = new LogRecord(80);
    long recordCount = 0L;
    long previousKey = 0L;
    boolean done = false;
    Exception exception = null;

    TestLogReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRecord(LogRecord lr) {
        if (lr.type == 19983) {
            TestLogReader testLogReader = this;
            synchronized (testLogReader) {
                this.done = true;
                this.notifyAll();
            }
        } else {
            ++this.recordCount;
            if (lr.key <= this.previousKey) {
                System.err.println("Key Out of Sequence; total/prev/this: " + this.recordCount + " / " + Long.toHexString(this.previousKey) + " / " + Long.toHexString(lr.key));
            }
        }
    }

    public void onError(LogException e) {
        this.exception = e;
        e.printStackTrace();
    }

    public LogRecord getLogRecord() {
        return this.logrec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(Logger log) throws Exception, LogException {
        log.replay(this, 0L);
        log.close();
        TestLogReader testLogReader = this;
        synchronized (testLogReader) {
            while (!this.done) {
                this.wait();
            }
        }
    }
}

