/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.IntValueHashMap;

public final class Types {
    public static final int ARRAY = 2003;
    public static final int BIGINT = -5;
    public static final int BINARY = -2;
    public static final int BLOB = 2004;
    public static final int BOOLEAN = 16;
    public static final int CHAR = 1;
    public static final int CLOB = 2005;
    public static final int DATALINK = 70;
    public static final int DATE = 91;
    public static final int DECIMAL = 3;
    public static final int DISTINCT = 2001;
    public static final int DOUBLE = 8;
    public static final int FLOAT = 6;
    public static final int INTEGER = 4;
    public static final int JAVA_OBJECT = 2000;
    public static final int LONGVARBINARY = -4;
    public static final int LONGVARCHAR = -1;
    public static final int NULL = 0;
    public static final int NUMERIC = 2;
    public static final int OTHER = 1111;
    public static final int REAL = 7;
    public static final int REF = 2006;
    public static final int SMALLINT = 5;
    public static final int STRUCT = 2002;
    public static final int TIME = 92;
    public static final int TIMESTAMP = 93;
    public static final int TINYINT = -6;
    public static final int VARBINARY = -3;
    public static final int VARCHAR = 12;
    public static final int XML = 137;
    public static final int TYPE_SUB_DEFAULT = 1;
    public static final int TYPE_SUB_IGNORECASE = 4;
    static final int[][] ALL_TYPES = new int[][]{{2003, 1}, {-5, 1}, {-2, 1}, {2004, 1}, {16, 1}, {1, 1}, {2005, 1}, {70, 1}, {91, 1}, {3, 1}, {2001, 1}, {8, 1}, {6, 1}, {4, 1}, {2000, 1}, {-4, 1}, {-1, 1}, {0, 1}, {2, 1}, {1111, 1}, {7, 1}, {2006, 1}, {5, 1}, {2002, 1}, {92, 1}, {93, 1}, {-6, 1}, {-3, 1}, {12, 1}, {12, 4}, {137, 1}};
    static final int SQL_CHARACTER = 1;
    static final int SQL_CHAR = 1;
    static final int SQL_NUMERIC = 2;
    static final int SQL_DECIMAL = 3;
    static final int SQL_DEC = 3;
    static final int SQL_INTEGER = 4;
    static final int SQL_INT = 4;
    static final int SQL_SMALLINT = 5;
    static final int SQL_FLOAT = 6;
    static final int SQL_REAL = 7;
    static final int SQL_DOUBLE = 8;
    static final int SQL_CHARACTER_VARYING = 12;
    static final int SQL_CHAR_VARYING = 12;
    static final int SQL_VARCHAR = 12;
    static final int SQL_BOOLEAN = 16;
    static final int SQL_USER_DEFINED_TYPE = 17;
    static final int SQL_ROW = 19;
    static final int SQL_REF = 20;
    static final int SQL_BIGINT = 25;
    static final int SQL_BINARY_LARGE_OBJECT = 30;
    static final int SQL_BLOB = 30;
    static final int SQL_CHARACTER_LARGE_OBJECT = 40;
    static final int SQL_CLOB = 40;
    static final int SQL_ARRAY = 50;
    static final int SQL_MULTISET = 55;
    static final int SQL_DATE = 91;
    static final int SQL_TIME = 92;
    static final int SQL_TIMESTAMP = 93;
    static final int SQL_TIME_WITH_TIME_ZONE = 94;
    static final int SQL_TIMESTAMP_WITH_TIME_ZONE = 95;
    static final int SQL_INTERVAL_YEAR = 101;
    static final int SQL_INTERVAL_MONTH = 102;
    static final int SQL_INTERVAL_DAY = 103;
    static final int SQL_INTERVAL_HOUR = 104;
    static final int SQL_INTERVAL_MINUTE = 105;
    static final int SQL_INTERVAL_SECOND = 106;
    static final int SQL_INTERVAL_YEAR_TO_MONTH = 107;
    static final int SQL_INTERVAL_DAY_TO_HOUR = 108;
    static final int SQL_INTERVAL_DAY_TO_MINUTE = 109;
    static final int SQL_INTERVAL_DAY_TO_SECOND = 110;
    static final int SQL_INTERVAL_HOUR_TO_MINUTE = 111;
    static final int SQL_INTERVAL_HOUR_TO_SECOND = 112;
    static final int SQL_INTERVAL_MINUTE_TO_SECOND = 113;
    static final int SQL_BIT_VARYING = 15;
    static final int SQL_DATALINK = 70;
    static final int SQL_UDT = 17;
    static final int SQL_UDT_LOCATOR = 18;
    static final int SQL_BLOB_LOCATOR = 31;
    static final int SQL_CLOB_LOCATOR = 41;
    static final int SQL_ARRAY_LOCATOR = 51;
    static final int SQL_MULTISET_LOCATOR = 56;
    static final int SQL_ALL_TYPES = 0;
    static final int SQL_DATETIME = 9;
    static final int SQL_INTERVAL = 10;
    static final int SQL_XML = 137;
    static final int SQL_DISTINCT = 1;
    static final int SQL_SCTRUCTURED = 2;
    public static final int VARCHAR_IGNORECASE = 100;
    static IntValueHashMap typeAliases = new IntValueHashMap(67, 1.0f);
    static IntKeyHashMap typeNames;
    static IntValueHashMap javaTypeNames;
    private static HashSet illegalParameterClasses;
    public static final int MAX_CHAR_OR_VARCHAR_DISPLAY_SIZE;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$io$Serializable;

    static int getTypeNr(String string) throws HsqlException {
        int n = typeAliases.get((Object)string, Integer.MIN_VALUE);
        Trace.check(n != Integer.MIN_VALUE, 16, string);
        return n;
    }

    public static String getTypeString(int n) {
        return (String)typeNames.get(n);
    }

    static int getParameterTypeNr(Class clazz) throws HsqlException {
        Trace.doAssert(clazz != null, "c is null");
        if (Void.TYPE.equals(clazz)) {
            return 0;
        }
        if (illegalParameterClasses.contains(clazz)) {
            throw Trace.error(16, 175, clazz.getName());
        }
        String string = clazz.getName();
        int n = typeAliases.get((Object)string, Integer.MIN_VALUE);
        if (n == Integer.MIN_VALUE) {
            if (clazz.isArray()) {
                while (clazz.isArray()) {
                    clazz = clazz.getComponentType();
                }
                if (clazz.isPrimitive() || (class$java$io$Serializable == null ? (class$java$io$Serializable = Types.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz)) {
                    n = 1111;
                }
            } else if ((class$java$io$Serializable == null ? (class$java$io$Serializable = Types.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz)) {
                n = 1111;
            }
        }
        Trace.check(n != Integer.MIN_VALUE, 16, string);
        return n;
    }

    public static boolean acceptsPrecisionCreateParam(int n) {
        switch (n) {
            case -3: 
            case -2: 
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 12: 
            case 100: 
            case 2004: 
            case 2005: {
                return true;
            }
        }
        return false;
    }

    public static int numericPrecisionCreateParamRadix(int n) {
        switch (n) {
            case 2: 
            case 3: {
                return 10;
            }
            case 6: {
                return 2;
            }
        }
        return 0;
    }

    public static boolean acceptsScaleCreateParam(int n) {
        switch (n) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumberType(int n) {
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCharacterType(int n) {
        switch (n) {
            case -1: 
            case 1: 
            case 12: 
            case 100: 
            case 2005: {
                return true;
            }
        }
        return false;
    }

    public static String getTypeName(int n) {
        switch (n) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
            case 100: {
                return "VARCHAR_IGNORECASE";
            }
            case 137: {
                return "XML";
            }
        }
        return null;
    }

    private static int MAX_CHAR_OR_VARCHAR_DISPLAY_SIZE() {
        try {
            return Integer.getInteger("hsqldb.max_char_or_varchar_display_size", 32766);
        }
        catch (SecurityException securityException) {
            return 32766;
        }
    }

    public static int getMaxDisplaySize(int n) {
        switch (n) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 137: 
            case 1111: {
                return Integer.MAX_VALUE;
            }
            case 1: 
            case 12: {
                return MAX_CHAR_OR_VARCHAR_DISPLAY_SIZE;
            }
            case -5: {
                return 20;
            }
            case 16: {
                return 5;
            }
            case 70: {
                return 20004;
            }
            case 2: 
            case 3: {
                return 646456995;
            }
            case 91: {
                return 10;
            }
            case 4: {
                return 11;
            }
            case 6: 
            case 7: 
            case 8: {
                return 23;
            }
            case 92: {
                return 8;
            }
            case 5: {
                return 6;
            }
            case 93: {
                return 29;
            }
            case -6: {
                return 4;
            }
        }
        return 0;
    }

    public static boolean isSearchable(int n) {
        switch (n) {
            case 1111: 
            case 2000: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: {
                return false;
            }
        }
        return true;
    }

    public static Boolean isCaseSensitive(int n) {
        switch (n) {
            case 0: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                return null;
            }
            case -1: 
            case 1: 
            case 70: 
            case 137: 
            case 1111: {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public static Boolean isUnsignedAttribute(int n) {
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static int getPrecision(int n) {
        switch (n) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 137: 
            case 1111: {
                return Integer.MAX_VALUE;
            }
            case -5: {
                return 19;
            }
            case 16: {
                return 1;
            }
            case 70: {
                return 20004;
            }
            case 2: 
            case 3: {
                return 646456993;
            }
            case 4: 
            case 91: {
                return 10;
            }
            case 6: 
            case 7: 
            case 8: {
                return 17;
            }
            case 92: {
                return 8;
            }
            case 5: {
                return 5;
            }
            case 93: {
                return 29;
            }
            case -6: {
                return 3;
            }
        }
        return 0;
    }

    public static String getColStClsName(int n) {
        switch (n) {
            case -5: {
                return "java.lang.Long";
            }
            case -4: 
            case -3: 
            case -2: {
                return "[B";
            }
            case 1111: {
                return "java.lang.Object";
            }
            case 16: {
                return "java.lang.Boolean";
            }
            case -1: 
            case 1: 
            case 12: 
            case 137: {
                return "java.lang.String";
            }
            case 70: {
                return "java.net.URL";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case 6: 
            case 7: 
            case 8: {
                return "java.lang.Double";
            }
            case -6: 
            case 4: 
            case 5: {
                return "java.lang.Integer";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        typeAliases.put("INTEGER", 4);
        typeAliases.put("INT", 4);
        typeAliases.put("int", 4);
        typeAliases.put("java.lang.Integer", 4);
        typeAliases.put("IDENTITY", 4);
        typeAliases.put("DOUBLE", 8);
        typeAliases.put("double", 8);
        typeAliases.put("java.lang.Double", 8);
        typeAliases.put("FLOAT", 6);
        typeAliases.put("REAL", 7);
        typeAliases.put("VARCHAR", 12);
        typeAliases.put("java.lang.String", 12);
        typeAliases.put("CHAR", 1);
        typeAliases.put("CHARACTER", 1);
        typeAliases.put("LONGVARCHAR", -1);
        typeAliases.put("VARCHAR_IGNORECASE", 100);
        typeAliases.put("DATE", 91);
        typeAliases.put("java.sql.Date", 91);
        typeAliases.put("TIME", 92);
        typeAliases.put("java.sql.Time", 92);
        typeAliases.put("TIMESTAMP", 93);
        typeAliases.put("java.sql.Timestamp", 93);
        typeAliases.put("DATETIME", 93);
        typeAliases.put("DECIMAL", 3);
        typeAliases.put("java.math.BigDecimal", 3);
        typeAliases.put("NUMERIC", 2);
        typeAliases.put("BIT", 16);
        typeAliases.put("BOOLEAN", 16);
        typeAliases.put("boolean", 16);
        typeAliases.put("java.lang.Boolean", 16);
        typeAliases.put("TINYINT", -6);
        typeAliases.put("byte", -6);
        typeAliases.put("java.lang.Byte", -6);
        typeAliases.put("SMALLINT", 5);
        typeAliases.put("short", 5);
        typeAliases.put("java.lang.Short", 5);
        typeAliases.put("BIGINT", -5);
        typeAliases.put("long", -5);
        typeAliases.put("java.lang.Long", -5);
        typeAliases.put("BINARY", -2);
        typeAliases.put("[B", -2);
        typeAliases.put("VARBINARY", -3);
        typeAliases.put("LONGVARBINARY", -4);
        typeAliases.put("OTHER", 1111);
        typeAliases.put("OBJECT", 1111);
        typeAliases.put("java.lang.Object", 1111);
        typeAliases.put("NULL", 0);
        typeAliases.put("void", 0);
        typeAliases.put("java.lang.Void", 0);
        typeNames = new IntKeyHashMap(37);
        typeNames.put(0, "NULL");
        typeNames.put(4, "INTEGER");
        typeNames.put(8, "DOUBLE");
        typeNames.put(100, "VARCHAR_IGNORECASE");
        typeNames.put(12, "VARCHAR");
        typeNames.put(1, "CHAR");
        typeNames.put(-1, "LONGVARCHAR");
        typeNames.put(91, "DATE");
        typeNames.put(92, "TIME");
        typeNames.put(3, "DECIMAL");
        typeNames.put(16, "BOOLEAN");
        typeNames.put(-6, "TINYINT");
        typeNames.put(5, "SMALLINT");
        typeNames.put(-5, "BIGINT");
        typeNames.put(7, "REAL");
        typeNames.put(6, "FLOAT");
        typeNames.put(2, "NUMERIC");
        typeNames.put(93, "TIMESTAMP");
        typeNames.put(-2, "BINARY");
        typeNames.put(-3, "VARBINARY");
        typeNames.put(-4, "LONGVARBINARY");
        typeNames.put(1111, "OBJECT");
        illegalParameterClasses = new HashSet(13);
        illegalParameterClasses.add(Byte.TYPE);
        illegalParameterClasses.add(Short.TYPE);
        illegalParameterClasses.add(Float.TYPE);
        illegalParameterClasses.add(class$java$lang$Byte == null ? (class$java$lang$Byte = Types.class$("java.lang.Byte")) : class$java$lang$Byte);
        illegalParameterClasses.add(class$java$lang$Short == null ? (class$java$lang$Short = Types.class$("java.lang.Short")) : class$java$lang$Short);
        illegalParameterClasses.add(class$java$lang$Float == null ? (class$java$lang$Float = Types.class$("java.lang.Float")) : class$java$lang$Float);
        MAX_CHAR_OR_VARCHAR_DISPLAY_SIZE = Types.MAX_CHAR_OR_VARCHAR_DISPLAY_SIZE();
    }
}

