/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.scriptio.ScriptReaderBase;

public class ScriptReaderText
extends ScriptReaderBase {
    BufferedReader d;

    ScriptReaderText(Database database, String string) throws HsqlException, IOException {
        super(database, string);
    }

    protected void readDDL(Session session) throws IOException, HsqlException {
        block1: {
            Result result;
            do {
                this.lastLine = this.readLoggedStatement();
                if (this.lastLine == null || this.lastLine.startsWith("INSERT INTO ")) break block1;
            } while ((result = session.sqlExecuteDirectNoPreChecks(this.lastLine)) == null || result.iMode != 2);
            throw Trace.error(78, 113, new Object[]{new Integer(this.lineCount), result.getMainString()});
        }
    }

    protected void readExistingData(Session session) throws IOException, HsqlException {
        this.db.setReferentialIntegrity(false);
        if (this.lastLine == null) {
            this.lastLine = this.readLoggedStatement();
        }
        while (this.lastLine != null) {
            Result result = session.sqlExecuteDirectNoPreChecks(this.lastLine);
            if (result != null && result.iMode == 2) {
                throw Trace.error(78, 114, new Object[]{new Integer(this.lineCount), result.getMainString()});
            }
            this.lastLine = this.readLoggedStatement();
        }
        this.db.setReferentialIntegrity(true);
    }

    public String readLoggedStatement() throws IOException {
        String string = this.d.readLine();
        ++this.lineCount;
        return StringConverter.asciiToUnicode(string);
    }

    protected void openFile() throws IOException {
        super.openFile();
        this.d = new BufferedReader(new InputStreamReader(this.dataStreamIn));
    }

    public void close() throws IOException {
        this.d.close();
        super.close();
    }
}

