/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractRepositoryTap;
import org.jreleaser.model.AbstractRepositoryTool;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class Spec
extends AbstractRepositoryTool {
    public static final String NAME = "spec";
    public static final String SKIP_SPEC = "skipSpec";
    private final List<String> requires = new ArrayList<String>();
    private final SpecRepository repository = new SpecRepository();
    private String packageName;
    private String release;

    public Spec() {
        super(NAME);
    }

    void setAll(Spec spec) {
        super.setAll(spec);
        this.packageName = spec.packageName;
        this.release = spec.release;
        this.setRepository(spec.repository);
        this.setRequires(spec.requires);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getRelease() {
        return this.release;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public SpecRepository getRepository() {
        return this.repository;
    }

    public void setRepository(SpecRepository repository) {
        this.repository.setAll(repository);
    }

    public List<String> getRequires() {
        return this.requires;
    }

    public void setRequires(List<String> requires) {
        this.requires.clear();
        this.requires.addAll(requires);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("packageName", this.packageName);
        props.put("release", this.release);
        props.put("requires", this.requires);
        props.put("repository", this.repository.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.repository;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isLinux((String)platform) && PlatformUtils.isIntel((String)platform) && !PlatformUtils.isAlpineLinux((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution distribution) {
        return distribution.getType() == Distribution.DistributionType.JAVA_BINARY || distribution.getType() == Distribution.DistributionType.JLINK || distribution.getType() == Distribution.DistributionType.NATIVE_IMAGE || distribution.getType() == Distribution.DistributionType.BINARY;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add(FileType.TAR_BZ2.extension());
        set.add(FileType.TAR_GZ.extension());
        set.add(FileType.TAR_XZ.extension());
        set.add(FileType.TBZ2.extension());
        set.add(FileType.TGZ.extension());
        set.add(FileType.TXZ.extension());
        set.add(FileType.TAR.extension());
        set.add(FileType.ZIP.extension());
        return set;
    }

    public static class SpecRepository
    extends AbstractRepositoryTap {
        public SpecRepository() {
            super(Spec.NAME, Spec.NAME);
        }
    }
}

