/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.Macports;
import org.jreleaser.model.validation.DistributionsValidator;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class MacportsValidator
extends Validator {
    public static void validateMacports(JReleaserContext context, Distribution distribution, Macports tool, Errors errors) {
        JReleaserModel model = context.getModel();
        Macports parentTool = model.getPackagers().getMacports();
        if (!tool.isActiveSet() && parentTool.isActiveSet()) {
            tool.setActive(parentTool.getActive());
        }
        if (!tool.resolveEnabled(context.getModel().getProject(), distribution)) {
            tool.disable();
            return;
        }
        GitService service = model.getRelease().getGitService();
        if (!service.isReleaseSupported()) {
            tool.disable();
            return;
        }
        context.getLogger().debug("distribution.{}.macports", new Object[]{distribution.getName()});
        if (null == tool.getRevision()) {
            tool.setRevision(parentTool.getRevision());
        }
        if (null == tool.getRevision()) {
            tool.setRevision(0);
        }
        if (tool.getMaintainers().isEmpty()) {
            tool.setMaintainers(parentTool.getMaintainers());
        }
        if (tool.getCategories().isEmpty()) {
            tool.setCategories(parentTool.getCategories());
        }
        if (tool.getCategories().isEmpty()) {
            tool.setCategories(Collections.singletonList("devel"));
        }
        MacportsValidator.validateCommitAuthor(tool, parentTool);
        Macports.MacportsRepository repository = tool.getRepository();
        repository.resolveEnabled(model.getProject());
        MacportsValidator.validateTap(context, distribution, repository, parentTool.getRepository(), "macports.repository");
        TemplateValidator.validateTemplate(context, distribution, tool, parentTool, errors);
        ExtraPropertiesValidator.mergeExtraProperties(tool, parentTool);
        MacportsValidator.validateContinueOnError(tool, parentTool);
        DistributionsValidator.validateArtifactPlatforms(context, distribution, tool, errors);
        if (StringUtils.isBlank((String)tool.getPackageName())) {
            tool.setPackageName(parentTool.getPackageName());
            if (StringUtils.isBlank((String)tool.getPackageName())) {
                tool.setPackageName(distribution.getName());
            }
        }
        Set<String> fileExtensions = tool.getSupportedExtensions();
        List candidateArtifacts = distribution.getArtifacts().stream().filter(Artifact::isActive).filter(artifact -> fileExtensions.stream().anyMatch(ext -> artifact.getPath().endsWith((String)ext))).filter(artifact -> tool.supportsPlatform(artifact.getPlatform())).filter(artifact -> !StringUtils.isTrue((Object)artifact.getExtraProperties().get("skipMacports"))).collect(Collectors.toList());
        if (candidateArtifacts.size() == 0) {
            tool.setActive(Active.NEVER);
            tool.disable();
        } else if (candidateArtifacts.size() > 1) {
            errors.configuration(RB.$((String)"validation_tool_multiple_artifacts", (Object[])new Object[]{"distribution." + distribution.getName() + ".macports"}));
            tool.disable();
        } else {
            context.getModel().getChecksum().getAlgorithms().add(Algorithm.RMD160);
        }
    }
}

