/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.Spec;
import org.jreleaser.model.validation.DistributionsValidator;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class SpecValidator
extends Validator {
    public static void validateSpec(JReleaserContext context, Distribution distribution, Spec tool, Errors errors) {
        List candidateArtifacts;
        JReleaserModel model = context.getModel();
        Spec parentTool = model.getPackagers().getSpec();
        if (!tool.isActiveSet() && parentTool.isActiveSet()) {
            tool.setActive(parentTool.getActive());
        }
        if (!tool.resolveEnabled(context.getModel().getProject(), distribution)) {
            tool.disable();
            return;
        }
        GitService service = model.getRelease().getGitService();
        if (!service.isReleaseSupported()) {
            tool.disable();
            return;
        }
        context.getLogger().debug("distribution.{}.spec", new Object[]{distribution.getName()});
        if (StringUtils.isBlank((String)tool.getRelease())) {
            tool.setRelease(parentTool.getRelease());
        }
        if (StringUtils.isBlank((String)tool.getRelease())) {
            tool.setRelease("1");
        }
        try {
            Integer.parseInt(tool.getRelease());
            tool.setRelease(tool.getRelease() + "%{?dist}");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (tool.getRequires().isEmpty()) {
            tool.setRequires(parentTool.getRequires());
        }
        if (tool.getRequires().isEmpty()) {
            tool.setRequires(Collections.singletonList("java"));
        }
        SpecValidator.validateCommitAuthor(tool, parentTool);
        Spec.SpecRepository repository = tool.getRepository();
        repository.resolveEnabled(model.getProject());
        SpecValidator.validateTap(context, distribution, repository, parentTool.getRepository(), "spec.repository");
        TemplateValidator.validateTemplate(context, distribution, tool, parentTool, errors);
        ExtraPropertiesValidator.mergeExtraProperties(tool, parentTool);
        SpecValidator.validateContinueOnError(tool, parentTool);
        DistributionsValidator.validateArtifactPlatforms(context, distribution, tool, errors);
        if (StringUtils.isBlank((String)tool.getPackageName())) {
            tool.setPackageName(parentTool.getPackageName());
            if (StringUtils.isBlank((String)tool.getPackageName())) {
                tool.setPackageName(distribution.getName());
            }
        }
        if ((candidateArtifacts = distribution.getArtifacts().stream().filter(Artifact::isActive).filter(artifact -> tool.getSupportedExtensions().stream().anyMatch(ext -> artifact.getPath().endsWith((String)ext))).filter(artifact -> tool.supportsPlatform(artifact.getPlatform())).filter(artifact -> !StringUtils.isTrue((Object)artifact.getExtraProperties().get("skipSpec"))).collect(Collectors.toList())).size() == 0) {
            tool.setActive(Active.NEVER);
            tool.disable();
        } else if (candidateArtifacts.size() > 1) {
            errors.configuration(RB.$((String)"validation_tool_multiple_artifacts", (Object[])new Object[]{"distribution." + distribution.getName() + ".spec"}));
            tool.disable();
        }
    }
}

