/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.tools;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Brew;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.tool.spi.ToolProcessingException;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.tools.AbstractRepositoryToolProcessor;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.FileType;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class BrewToolProcessor
extends AbstractRepositoryToolProcessor<Brew> {
    private static final String KEY_DISTRIBUTION_CHECKSUM_SHA_256 = "distributionChecksumSha256";
    private static final String TPL_MAC_ARM = "  if OS.mac? && Hardware::CPU.arm?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n  end\n";
    private static final String TPL_MAC_INTEL = "  if OS.mac? && Hardware::CPU.intel?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n  end\n";
    private static final String TPL_LINUX_ARM = "  if OS.linux? && Hardware::CPU.arm? && Hardware::CPU.is_64_bit?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n  end\n";
    private static final String TPL_LINUX_INTEL = "  if OS.linux? && Hardware::CPU.intel?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n  end\n";
    private static final String CASK_RB = "cask.rb";
    private static final String CASKS = "Casks";
    private static final String FORMULA = "Formula";
    private static final String FORMULA_RB = "formula.rb";
    private static final String FORMULA_MULTI_RB = "formula-multi.rb";
    private static final String RB = ".rb";
    private static final String SKIP_JAVA = "skipJava";

    public BrewToolProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws ToolProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
    }

    @Override
    protected void fillToolProperties(Map<String, Object> props, Distribution distribution) throws ToolProcessingException {
        Brew.Cask cask;
        GitService gitService = this.context.getModel().getRelease().getGitService();
        props.put("brewFormulaName", ((Brew)this.tool).getResolvedFormulaName(props));
        props.put("brewTapRepoUrl", gitService.getResolvedRepoUrl(this.context.getModel(), ((Brew)this.tool).getTap().getOwner(), ((Brew)this.tool).getTap().getResolvedName()));
        props.put("brewTapRepoCloneUrl", gitService.getResolvedRepoCloneUrl(this.context.getModel(), ((Brew)this.tool).getTap().getOwner(), ((Brew)this.tool).getTap().getResolvedName()));
        props.put("brewHasLivecheck", ((Brew)this.tool).hasLivecheck());
        if (((Brew)this.tool).hasLivecheck()) {
            props.put("brewLivecheck", ((Brew)this.tool).getLivecheck().stream().map(line -> MustacheUtils.applyTemplate((String)line, (Map)props)).map(MustacheUtils::passThrough).collect(Collectors.toList()));
        }
        if ((cask = ((Brew)this.tool).getCask()).isEnabled()) {
            boolean hasPkg = StringUtils.isNotBlank((String)cask.getPkgName());
            boolean hasApp = StringUtils.isNotBlank((String)cask.getAppName());
            props.put("brewCaskName", cask.getResolvedCaskName(props));
            props.put("brewCaskDisplayName", cask.getResolvedDisplayName(props));
            props.put("brewCaskHasUninstall", !cask.getUninstallItems().isEmpty());
            props.put("brewCaskHasPkg", hasPkg);
            if (hasPkg) {
                props.put("brewCaskPkg", cask.getResolvedPkgName(props));
            }
            props.put("brewCaskHasApp", hasApp);
            if (hasApp) {
                props.put("brewCaskApp", cask.getResolvedAppName(props));
            }
            props.put("brewCaskUninstall", cask.getUninstallItems());
            props.put("brewCaskHasZap", !cask.getZapItems().isEmpty());
            props.put("brewCaskZap", cask.getZapItems());
            String appcast = cask.getResolvedAppcast(props);
            props.put("brewCaskHasAppcast", StringUtils.isNotBlank((String)appcast));
            props.put("brewCaskAppcast", appcast);
            if (!hasApp && !hasPkg) {
                for (Artifact artifact : this.collectArtifacts(distribution)) {
                    if (!artifact.getPath().endsWith(FileType.ZIP.extension())) continue;
                    props.put("distributionUrl", this.resolveArtifactUrl(props, distribution, artifact));
                    props.put("brewCaskHasBinary", true);
                    break;
                }
            }
        } else if (((Brew)this.tool).isMultiPlatform()) {
            ArrayList<String> multiPlatforms = new ArrayList<String>();
            for (Artifact artifact : this.collectArtifacts(distribution)) {
                if (!artifact.getPath().endsWith(FileType.ZIP.extension()) || StringUtils.isBlank((String)artifact.getPlatform())) continue;
                String template = null;
                String artifactUrl = this.resolveArtifactUrl(props, distribution, artifact);
                if (PlatformUtils.isMac((String)artifact.getPlatform())) {
                    template = PlatformUtils.isArm((String)artifact.getPlatform()) ? TPL_MAC_ARM : TPL_MAC_INTEL;
                } else if (PlatformUtils.isLinux((String)artifact.getPlatform())) {
                    template = PlatformUtils.isArm((String)artifact.getPlatform()) ? TPL_LINUX_ARM : TPL_LINUX_INTEL;
                }
                if (!StringUtils.isNotBlank((String)template)) continue;
                LinkedHashMap<String, Object> newProps = new LinkedHashMap<String, Object>(props);
                newProps.put("distributionUrl", artifactUrl);
                newProps.put(KEY_DISTRIBUTION_CHECKSUM_SHA_256, artifact.getHash(Algorithm.SHA_256));
                multiPlatforms.add(MustacheUtils.applyTemplate((String)template, newProps));
            }
            if (multiPlatforms.isEmpty()) {
                throw new ToolProcessingException(org.jreleaser.bundle.RB.$((String)"ERROR_brew_multiplatform_artifacts", (Object[])new Object[0]));
            }
            props.put("brewMultiPlatform", MustacheUtils.passThrough((String)String.join((CharSequence)(System.lineSeparator() + "  "), multiPlatforms)));
        } else if (!(distribution.getType() != Distribution.DistributionType.JAVA_BINARY && distribution.getType() != Distribution.DistributionType.SINGLE_JAR || StringUtils.isTrue(((Brew)this.tool).getExtraProperties().get(SKIP_JAVA)))) {
            ((Brew)this.tool).addDependency("openjdk@" + props.get("distributionJavaVersion"));
        }
        props.put("brewDependencies", ((Brew)this.tool).getDependenciesAsList().stream().map(dependency -> MustacheUtils.passThrough((String)dependency.toString())).collect(Collectors.toList()));
    }

    @Override
    protected boolean isSkipped(Artifact artifact) {
        return StringUtils.isTrue(artifact.getExtraProperties().get("skipBrew"));
    }

    private String resolveArtifactUrl(Map<String, Object> props, Distribution distribution, Artifact artifact) {
        String artifactFile = artifact.getEffectivePath(this.context, distribution).getFileName().toString();
        String artifactFileName = StringUtils.getFilename((String)artifactFile, (Collection)((Brew)this.tool).getSupportedExtensions());
        String artifactExtension = artifactFile.substring(artifactFileName.length() + 1);
        String artifactFileFormat = artifactExtension.substring(1);
        LinkedHashMap<String, Object> newProps = new LinkedHashMap<String, Object>(props);
        newProps.put("artifactFile", artifactFile);
        newProps.put("artifactFileName", artifactFileName);
        newProps.put("artifactFileFormat", artifactFileFormat);
        newProps.put("artifactArchiveFormat", artifactFileFormat);
        String platform = artifact.getPlatform();
        if (StringUtils.isNotBlank((String)platform)) {
            newProps.put("artifactPlatform", platform);
        }
        String platformReplaced = distribution.getPlatform().applyReplacements(platform);
        if (StringUtils.isNotBlank((String)platform)) {
            newProps.put("artifactPlatformReplaced", platformReplaced);
        }
        if (StringUtils.isNotBlank((String)platform)) {
            newProps.put("distributionArtifactPlatform", platform);
        }
        if (StringUtils.isNotBlank((String)platform)) {
            newProps.put("distributionArtifactPlatformReplaced", platformReplaced);
        }
        newProps.put("distributionArtifactFile", artifactFile);
        newProps.put("distributionArtifactFileName", artifactFileName);
        newProps.put("distributionArtifactFileFormat", artifactFileFormat);
        newProps.put("distributionArtifactArchiveFormat", artifactFileFormat);
        return MustacheUtils.applyTemplate((String)this.context.getModel().getRelease().getGitService().getDownloadUrl(), newProps);
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws ToolProcessingException {
        fileName = TemplateUtils.trimTplExtension((String)fileName);
        if (((Brew)this.tool).getCask().isEnabled()) {
            if (FORMULA_RB.equals(fileName) || FORMULA_MULTI_RB.equals(fileName)) {
                return;
            }
            Path outputFile = CASK_RB.equals(fileName) ? outputDirectory.resolve(CASKS).resolve(((Brew)this.tool).getCask().getResolvedCaskName(props).concat(RB)) : outputDirectory.resolve(fileName);
            this.writeFile(content, outputFile);
        } else if (((Brew)this.tool).isMultiPlatform()) {
            if (CASK_RB.equals(fileName) || FORMULA_RB.equals(fileName)) {
                return;
            }
            Path outputFile = FORMULA_MULTI_RB.equals(fileName) ? outputDirectory.resolve(FORMULA).resolve(distribution.getExecutable().concat(RB)) : outputDirectory.resolve(fileName);
            this.writeFile(content, outputFile);
        } else {
            if (CASK_RB.equals(fileName) || FORMULA_MULTI_RB.equals(fileName)) {
                return;
            }
            Path outputFile = FORMULA_RB.equals(fileName) ? outputDirectory.resolve(FORMULA).resolve(distribution.getExecutable().concat(RB)) : outputDirectory.resolve(fileName);
            this.writeFile(content, outputFile);
        }
    }
}

