/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.tools;

import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Gofish;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.tool.spi.ToolProcessingException;
import org.jreleaser.model.util.Artifacts;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.tools.AbstractRepositoryToolProcessor;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.FileType;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class GofishToolProcessor
extends AbstractRepositoryToolProcessor<Gofish> {
    public GofishToolProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws ToolProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
    }

    @Override
    protected void fillToolProperties(Map<String, Object> props, Distribution distribution) throws ToolProcessingException {
        List<Artifact> artifacts = this.collectArtifacts(distribution);
        List packages = artifacts.stream().filter(artifact -> StringUtils.isNotBlank((String)artifact.getPlatform())).map(artifact -> new GofishPackage(props, this.context, distribution, (Artifact)artifact)).collect(Collectors.toList());
        if (packages.isEmpty()) {
            for (Artifact artifact2 : artifacts) {
                if (StringUtils.isNotBlank((String)artifact2.getPlatform())) continue;
                for (String os : new String[]{"darwin", "linux", "windows"}) {
                    for (String arch : new String[]{"x86_64", "aarch64"}) {
                        Artifact copy = artifact2.copy();
                        copy.setPlatform(os + "-" + arch);
                        packages.add(new GofishPackage(props, this.context, distribution, copy));
                    }
                }
            }
        }
        props.put("gofishPackages", packages);
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws ToolProcessingException {
        Path outputFile = "food.lua".equals(fileName = TemplateUtils.trimTplExtension((String)fileName)) ? outputDirectory.resolve("Food").resolve(distribution.getExecutable().concat(".lua")) : outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }

    @Override
    protected boolean isSkipped(Artifact artifact) {
        return StringUtils.isTrue(artifact.getExtraProperties().get("skipGofish"));
    }

    private static class GofishPackage {
        private final String packageOs;
        private final String packageArch;
        private final String packageUrl;
        private final String packageChecksum;
        private final String packagePath;
        private final String packageInstallPath;

        public GofishPackage(Map<String, Object> props, JReleaserContext context, Distribution distribution, Artifact artifact) {
            String platform = artifact.getPlatform();
            String artifactPlatform = StringUtils.isNotBlank((String)platform) ? StringUtils.capitalize((String)platform) : "";
            Map artifactProps = artifact.getResolvedExtraProperties("artifact" + artifactPlatform);
            artifactProps.keySet().stream().filter(k -> !props.containsKey(k)).forEach(k -> props.put((String)k, artifactProps.get(k)));
            String artifactFile = artifact.getEffectivePath().getFileName().toString();
            String artifactFileName = StringUtils.getFilename((String)artifactFile, (Collection)FileType.getSupportedExtensions());
            boolean windows = PlatformUtils.isWindows((String)platform);
            String executable = distribution.getExecutable();
            String projectVersion = context.getModel().getProject().getVersion();
            String ps = windows ? "\\\\" : "/";
            String installPath = "\"bin" + ps + "\" .. name";
            String executablePath = artifactFileName.replace(executable, "name .. \"").replace(projectVersion, "\" .. version .. \"") + ps + "bin" + ps + "\" .. name";
            if (windows) {
                executablePath = executablePath + " .. \"." + distribution.getExecutableExtension() + "\"";
                installPath = installPath + " .. \"." + distribution.getExecutableExtension() + "\"";
            }
            this.packagePath = executablePath;
            this.packageInstallPath = installPath;
            String artifactOs = "";
            String artifactArch = "";
            if (StringUtils.isNotBlank((String)platform) && platform.contains("-")) {
                String[] parts = platform.split("-");
                artifactOs = parts[0];
                artifactArch = parts[1];
            }
            this.packageOs = "osx".equals(artifactOs) ? "darwin" : artifactOs;
            this.packageArch = "x86_64".equals(artifactArch) ? "amd64" : "arm64";
            this.packageChecksum = artifact.getHash(Algorithm.SHA_256);
            LinkedHashMap<String, Object> newProps = new LinkedHashMap<String, Object>(props);
            Artifacts.artifactProps((Artifact)artifact, newProps);
            String url = MustacheUtils.applyTemplate((String)context.getModel().getRelease().getGitService().getDownloadUrl(), newProps);
            this.packageUrl = url.replace(executable, "\" .. name .. \"").replace(projectVersion, "\" .. version .. \"");
        }

        public String getPackageOs() {
            return this.packageOs;
        }

        public String getPackageArch() {
            return this.packageArch;
        }

        public String getPackageUrl() {
            return MustacheUtils.passThrough((String)this.packageUrl);
        }

        public String getPackageChecksum() {
            return this.packageChecksum;
        }

        public String getPackagePath() {
            return MustacheUtils.passThrough((String)this.packagePath);
        }

        public String getPackageInstallPath() {
            return MustacheUtils.passThrough((String)this.packageInstallPath);
        }
    }
}

