/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Jbang;
import org.jreleaser.model.Project;
import org.jreleaser.model.tool.spi.ToolProcessingException;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.tools.AbstractRepositoryToolProcessor;
import org.jreleaser.util.JsonUtils;
import org.jreleaser.util.StringUtils;

public class JbangToolProcessor
extends AbstractRepositoryToolProcessor<Jbang> {
    public JbangToolProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    public boolean supportsDistribution(Distribution distribution) {
        return distribution.getType() != Distribution.DistributionType.JLINK;
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws ToolProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
    }

    @Override
    protected boolean verifyAndAddArtifacts(Map<String, Object> props, Distribution distribution) throws ToolProcessingException {
        return true;
    }

    @Override
    protected void fillToolProperties(Map<String, Object> props, Distribution distribution) throws ToolProcessingException {
        String aliasName;
        GitService gitService = this.context.getModel().getRelease().getGitService();
        props.put("jbangCatalogRepoUrl", gitService.getResolvedRepoUrl(this.context.getModel(), ((Jbang)this.tool).getCatalog().getOwner(), ((Jbang)this.tool).getCatalog().getResolvedName()));
        props.put("jbangCatalogRepoCloneUrl", gitService.getResolvedRepoCloneUrl(this.context.getModel(), ((Jbang)this.tool).getCatalog().getOwner(), ((Jbang)this.tool).getCatalog().getResolvedName()));
        String scriptName = aliasName = this.sanitizeAlias(((Jbang)this.tool).getAlias());
        if (this.context.getModel().getProject().isSnapshot()) {
            aliasName = aliasName + "-snapshot";
            scriptName = scriptName + "_snapshot";
        }
        scriptName = this.sanitizeScriptName(scriptName);
        props.put("jbangAliasName", aliasName);
        props.put("jbangScriptName", scriptName);
        String jbangDistributionGA = (String)((Jbang)this.tool).getResolvedExtraProperties().get("jbangDistributionGA");
        if (StringUtils.isBlank((String)jbangDistributionGA)) {
            if (this.context.getModel().getProject().isSnapshot()) {
                String reverseRepoHost = gitService.getReverseRepoHost();
                if (((Jbang)this.tool).getExtraProperties().containsKey("reverseDomain")) {
                    reverseRepoHost = (String)((Jbang)this.tool).getExtraProperties().get("reverseDomain");
                } else if (StringUtils.isBlank((String)reverseRepoHost)) {
                    reverseRepoHost = (String)((Jbang)this.tool).getExtraProperties().get("reverseRepoHost");
                }
                StringBuilder b = new StringBuilder(reverseRepoHost).append(".").append(gitService.getOwner());
                if (distribution.getJava().isMultiProject()) {
                    b.append(".").append(gitService.getName());
                }
                b.append(":").append(distribution.getJava().getArtifactId());
                jbangDistributionGA = b.toString();
            } else {
                jbangDistributionGA = distribution.getJava().getGroupId() + ":" + distribution.getJava().getArtifactId();
            }
        }
        props.put("jbangDistributionGA", jbangDistributionGA);
    }

    private String sanitizeAlias(String alias) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < alias.length(); ++i) {
            char ch = alias.charAt(i);
            if (!Character.isJavaIdentifierPart(ch) && ch != '-') continue;
            b.append(ch);
        }
        return b.toString();
    }

    private String sanitizeScriptName(String scriptName) {
        scriptName = scriptName.replaceAll("-", "_");
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < scriptName.length(); ++i) {
            char ch = scriptName.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) continue;
            b.append(ch);
        }
        return b.toString();
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws ToolProcessingException {
        fileName = TemplateUtils.trimTplExtension((String)fileName);
        String scriptName = (String)props.get("jbangScriptName");
        Path outputFile = "jbang.java".equals(fileName) ? outputDirectory.resolve(scriptName.concat(".java")) : outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }

    @Override
    protected void prepareWorkingCopy(Map<String, Object> props, Path directory, Distribution distribution) throws ToolProcessingException, IOException {
        Path catalog = directory.resolve("jbang-catalog.json");
        if (catalog.toFile().exists()) {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode previous = objectMapper.readTree(Files.readAllBytes(catalog));
            super.prepareWorkingCopy(props, directory, distribution);
            JsonNode current = objectMapper.readTree(Files.readAllBytes(catalog));
            JsonNode merged = JsonUtils.merge((JsonNode)previous, (JsonNode)current);
            Files.write(catalog, merged.toPrettyString().getBytes(), new OpenOption[0]);
        } else {
            super.prepareWorkingCopy(props, directory, distribution);
        }
    }
}

