/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.tools;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Sdkman;
import org.jreleaser.model.tool.spi.ToolProcessingException;
import org.jreleaser.sdk.sdkman.MajorReleaseSdkmanCommand;
import org.jreleaser.sdk.sdkman.MinorReleaseSdkmanCommand;
import org.jreleaser.sdk.sdkman.SdkmanException;
import org.jreleaser.tools.AbstractToolProcessor;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;

public class SdkmanToolProcessor
extends AbstractToolProcessor<Sdkman> {
    public SdkmanToolProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPrepareDistribution(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
    }

    @Override
    protected void doPublishDistribution(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        Sdkman sdkman = distribution.getSdkman();
        LinkedHashMap<String, String> platforms = new LinkedHashMap<String, String>();
        for (Artifact artifact : distribution.getArtifacts()) {
            if (!artifact.isActive()) continue;
            if (!artifact.getPath().endsWith(".zip")) {
                this.context.getLogger().debug(RB.$((String)"sdkman.no.artifacts.match", (Object[])new Object[0]), new Object[]{artifact.getEffectivePath(this.context, distribution).getFileName()});
                continue;
            }
            if (StringUtils.isTrue(artifact.getExtraProperties().get("skipSdkman"))) {
                this.context.getLogger().debug(RB.$((String)"sdkman.artifact.explicit.skip", (Object[])new Object[0]), new Object[]{artifact.getEffectivePath(this.context, distribution).getFileName()});
                continue;
            }
            String platform = this.mapPlatform(artifact.getPlatform());
            String url = this.artifactUrl(distribution, artifact);
            if (platforms.containsKey(platform)) {
                this.context.getLogger().warn(RB.$((String)"sdkman.platform.replacement", (Object[])new Object[0]), new Object[]{platform, url, platforms.get(platform)});
            }
            platforms.put(platform, url);
        }
        try {
            String candidate = StringUtils.isNotBlank((String)sdkman.getCandidate()) ? sdkman.getCandidate().trim() : this.context.getModel().getProject().getName();
            String releaseNotesUrl = MustacheUtils.applyTemplate((String)sdkman.getReleaseNotesUrl(), props);
            switch (sdkman.getCommand()) {
                case MAJOR: {
                    this.context.getLogger().info(RB.$((String)"sdkman.publish.major", (Object[])new Object[0]), new Object[]{candidate});
                    ((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)MajorReleaseSdkmanCommand.builder((JReleaserLogger)this.context.getLogger()).connectTimeout(sdkman.getConnectTimeout())).readTimeout(sdkman.getReadTimeout())).consumerKey(this.context.isDryrun() ? "**UNDEFINED**" : sdkman.getResolvedConsumerKey())).consumerToken(this.context.isDryrun() ? "**UNDEFINED**" : sdkman.getResolvedConsumerToken())).candidate(candidate)).version(this.context.getModel().getProject().getVersion())).platforms(platforms).releaseNotesUrl(releaseNotesUrl).dryrun(this.context.isDryrun())).skipAnnounce(true)).build().execute();
                    break;
                }
                case MINOR: {
                    this.context.getLogger().info(RB.$((String)"sdkman.publish.minor", (Object[])new Object[0]), new Object[]{candidate});
                    ((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)MinorReleaseSdkmanCommand.builder((JReleaserLogger)this.context.getLogger()).connectTimeout(sdkman.getConnectTimeout())).readTimeout(sdkman.getReadTimeout())).consumerKey(this.context.isDryrun() ? "**UNDEFINED**" : sdkman.getResolvedConsumerKey())).consumerToken(this.context.isDryrun() ? "**UNDEFINED**" : sdkman.getResolvedConsumerToken())).candidate(candidate)).version(this.context.getModel().getProject().getVersion())).platforms(platforms).releaseNotesUrl(releaseNotesUrl).dryrun(this.context.isDryrun())).skipAnnounce(true)).build().execute();
                }
            }
            sdkman.setPublished(true);
        }
        catch (SdkmanException e) {
            throw new ToolProcessingException((Throwable)e);
        }
    }

    @Override
    protected void fillToolProperties(Map<String, Object> props, Distribution distribution) throws ToolProcessingException {
        props.put("sdkmanCandidate", ((Sdkman)this.tool).getCandidate());
        props.put("sdkmanReleaseNotesUrl", MustacheUtils.applyTemplate((String)((Sdkman)this.tool).getReleaseNotesUrl(), props));
    }

    private String mapPlatform(String platform) {
        if (StringUtils.isBlank((String)platform)) {
            return "UNIVERSAL";
        }
        if (platform.contains("mac") || platform.contains("osx")) {
            return platform.contains("aarch_64") ? "MAC_ARM64" : "MAC_OSX";
        }
        if (platform.contains("win")) {
            return "WINDOWS_64";
        }
        if (platform.contains("linux")) {
            if (platform.contains("x86_32")) {
                return "LINUX_32";
            }
            if (platform.contains("x86_64")) {
                return "LINUX_64";
            }
            if (platform.contains("arm_32")) {
                return "LINUX_ARM32";
            }
            if (platform.contains("aarch_64")) {
                return "LINUX_ARM64";
            }
            return "LINUX_32";
        }
        return null;
    }

    private String artifactUrl(Distribution distribution, Artifact artifact) {
        Map newProps = this.context.props();
        newProps.put("artifactFile", artifact.getEffectivePath(this.context, distribution).getFileName().toString());
        return MustacheUtils.applyTemplate((String)this.context.getModel().getRelease().getGitService().getDownloadUrl(), (Map)newProps, (String)"downloadUrl");
    }
}

