/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.github;

import java.io.IOException;
import java.util.LinkedHashMap;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Discussions;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.announcer.spi.AnnounceException;
import org.jreleaser.model.announcer.spi.Announcer;
import org.jreleaser.sdk.github.Github;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;

public class DiscussionsAnnouncer
implements Announcer {
    private final JReleaserContext context;

    DiscussionsAnnouncer(JReleaserContext context) {
        this.context = context;
    }

    public String getName() {
        return "discussions";
    }

    public boolean isEnabled() {
        return this.context.getModel().getAnnounce().getDiscussions().isEnabled();
    }

    public void announce() throws AnnounceException {
        org.jreleaser.model.Github github = this.context.getModel().getRelease().getGithub();
        Discussions discussions = this.context.getModel().getAnnounce().getDiscussions();
        String message = "";
        if (StringUtils.isNotBlank((String)discussions.getMessage())) {
            message = discussions.getResolvedMessage(this.context);
        } else {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            props.put("changelog", MustacheUtils.passThrough((String)this.context.getChangelog()));
            this.context.getModel().getRelease().getGitService().fillProps(props, this.context.getModel());
            message = discussions.getResolvedMessageTemplate(this.context, props);
        }
        String title = discussions.getResolvedTitle(this.context);
        this.context.getLogger().info("title: {}", new Object[]{title});
        this.context.getLogger().debug("message: {}", new Object[]{message});
        try {
            Github api = new Github(this.context.getLogger(), github.getApiEndpoint(), github.getResolvedToken(), discussions.getConnectTimeout(), discussions.getReadTimeout());
            if (api.findDiscussion(discussions.getOrganization(), discussions.getTeam(), title).isPresent()) {
                throw new IllegalStateException(RB.$((String)"ERROR_git_discussion_duplicate", (Object[])new Object[]{title, discussions.getOrganization(), discussions.getTeam()}));
            }
            api.createDiscussion(discussions.getOrganization(), discussions.getTeam(), title, message);
        }
        catch (IOException | IllegalStateException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new AnnounceException((Throwable)e);
        }
    }
}

