/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Http;
import org.jreleaser.model.HttpUploader;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class HttpValidator
extends Validator {
    public static void validateHttp(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("http");
        Map<String, Http> http = context.getModel().getUpload().getHttp();
        for (Map.Entry<String, Http> e : http.entrySet()) {
            e.getValue().setName(e.getKey());
            HttpValidator.validateHttp(context, mode, e.getValue(), errors);
        }
    }

    private static void validateHttp(JReleaserContext context, JReleaserContext.Mode mode, Http http, Errors errors) {
        context.getLogger().debug("http.{}", new Object[]{http.getName()});
        if (!http.isActiveSet()) {
            http.setActive(Active.NEVER);
        }
        if (!http.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        if (!(http.isArtifacts().booleanValue() || http.isFiles().booleanValue() || http.isSignatures().booleanValue())) {
            http.disable();
            return;
        }
        if (StringUtils.isBlank((String)http.getUploadUrl())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"http." + http.getName() + ".uploadUrl"}));
        }
        if (StringUtils.isBlank((String)http.getDownloadUrl())) {
            http.setDownloadUrl(http.getUploadUrl());
        }
        if (null == http.getMethod()) {
            http.setMethod(HttpUploader.Method.PUT);
        }
        switch (http.resolveAuthorization()) {
            case BEARER: {
                http.setPassword(HttpValidator.checkProperty(context, "HTTP_" + Env.toVar((String)http.getName()) + "_PASSWORD", "http.password", http.getPassword(), errors, context.isDryrun()));
                break;
            }
            case BASIC: {
                http.setUsername(HttpValidator.checkProperty(context, "HTTP_" + Env.toVar((String)http.getName()) + "_USERNAME", "http.username", http.getUsername(), errors, context.isDryrun()));
                http.setPassword(HttpValidator.checkProperty(context, "HTTP_" + Env.toVar((String)http.getName()) + "_PASSWORD", "http.password", http.getPassword(), errors, context.isDryrun()));
                break;
            }
        }
        HttpValidator.validateTimeout(http);
    }
}

