/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Scanner;

final class Banner {
    private static final Banner b = new Banner();
    private final ResourceBundle bundle = ResourceBundle.getBundle(Banner.class.getName());
    private final String productVersion = this.bundle.getString("product.version");
    private final String productId = this.bundle.getString("product.id");
    private final String productName = this.bundle.getString("product.name");
    private final String banner = MessageFormat.format(this.bundle.getString("product.banner"), this.productName, this.productVersion);

    private Banner() {
    }

    public static void display(PrintWriter out) {
        try {
            File parent;
            File markerFile;
            File dir;
            File jreleaserDir = new File(System.getProperty("user.home"));
            String envJreleaserDir = System.getenv("JRELEASER_DIR");
            if (envJreleaserDir != null && !envJreleaserDir.isEmpty() && (dir = new File(envJreleaserDir)).exists()) {
                jreleaserDir = dir;
            }
            if (!(markerFile = Banner.getMarkerFile(parent = new File(jreleaserDir, "/.jreleaser/caches"), b)).exists()) {
                out.println(Banner.b.banner);
                markerFile.getParentFile().mkdirs();
                PrintStream fout = new PrintStream(new FileOutputStream(markerFile));
                fout.println("1");
                fout.close();
                Banner.writeQuietly(markerFile, "1");
            } else {
                try {
                    int count = Integer.parseInt(Banner.readQuietly(markerFile));
                    if (count < 3) {
                        out.println(Banner.b.banner);
                    }
                    Banner.writeQuietly(markerFile, count + 1 + "");
                }
                catch (NumberFormatException e) {
                    Banner.writeQuietly(markerFile, "1");
                    out.println(Banner.b.banner);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeQuietly(File file, String text) {
        try {
            PrintStream out = new PrintStream(new FileOutputStream(file));
            out.println(text);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String readQuietly(File file) {
        try {
            Scanner in = new Scanner(new FileInputStream(file));
            return in.next();
        }
        catch (Exception ignored) {
            return "";
        }
    }

    private static File getMarkerFile(File parent, Banner b) {
        return new File(parent, "jreleaser" + File.separator + b.productId + File.separator + b.productVersion + File.separator + "marker.txt");
    }
}

