/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.releaser.spi;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Checksum;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Signing;
import org.jreleaser.model.releaser.spi.Asset;
import org.jreleaser.model.releaser.spi.Releaser;
import org.jreleaser.model.releaser.spi.ReleaserBuilder;
import org.jreleaser.model.util.Artifacts;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.StringUtils;

public abstract class AbstractReleaserBuilder<R extends Releaser>
implements ReleaserBuilder<R> {
    protected final List<Asset> assets = new ArrayList<Asset>();
    protected JReleaserContext context;

    @Override
    public ReleaserBuilder<R> addReleaseAsset(Asset asset) {
        if (null != asset) {
            this.assets.add(asset);
        }
        return this;
    }

    @Override
    public ReleaserBuilder<R> addReleaseAssets(Path assets) {
        if (assets.toFile().exists()) {
            for (File asset : assets.toFile().listFiles()) {
                this.addReleaseAsset(Asset.file(Artifact.of(asset.toPath().toAbsolutePath())));
            }
        }
        return this;
    }

    @Override
    public ReleaserBuilder<R> setReleaseAssets(List<Asset> assets) {
        if (null != assets) {
            this.assets.addAll(assets);
        }
        return this;
    }

    protected void validate() {
        Objects.requireNonNull(this.context, "'context' must not be null");
    }

    @Override
    public ReleaserBuilder<R> configureWith(JReleaserContext context) {
        Signing signing;
        this.context = context;
        GitService service = context.getModel().getRelease().getGitService();
        if (!service.resolveUploadAssetsEnabled(context.getModel().getProject())) {
            return this;
        }
        ArrayList<Asset> assets = new ArrayList<Asset>();
        Checksum checksum = context.getModel().getChecksum();
        if (service.isFiles().booleanValue()) {
            for (Artifact artifact : Artifacts.resolveFiles(context)) {
                if (!artifact.isActive() || artifact.extraPropertyIsTrue("skipRelease")) continue;
                Path path = artifact.getEffectivePath(context);
                assets.add(Asset.file(Artifact.of(path, artifact.getExtraProperties())));
                if (!service.isChecksums().booleanValue() || !this.isIndividual(context, artifact) || artifact.extraPropertyIsTrue("skipChecksum")) continue;
                for (Algorithm algorithm : checksum.getAlgorithms()) {
                    assets.add(Asset.checksum(Artifact.of(context.getChecksumsDirectory().resolve(path.getFileName() + "." + algorithm.formatted()))));
                }
            }
        }
        if (service.isArtifacts().booleanValue()) {
            for (Distribution distribution : context.getModel().getActiveDistributions()) {
                if (distribution.extraPropertyIsTrue("skipRelease")) continue;
                for (Artifact artifact : distribution.getArtifacts()) {
                    if (!artifact.isActive() || artifact.extraPropertyIsTrue("skipRelease")) continue;
                    Path path = artifact.getEffectivePath(context, distribution);
                    assets.add(Asset.file(Artifact.of(path, artifact.getExtraProperties()), distribution));
                    if (!service.isChecksums().booleanValue() || !this.isIndividual(context, distribution, artifact)) continue;
                    for (Algorithm algorithm : checksum.getAlgorithms()) {
                        assets.add(Asset.checksum(Artifact.of(context.getChecksumsDirectory().resolve(distribution.getName()).resolve(path.getFileName() + "." + algorithm.formatted()))));
                    }
                }
            }
        }
        if (service.isChecksums().booleanValue()) {
            for (Algorithm algorithm : checksum.getAlgorithms()) {
                Path checksums = context.getChecksumsDirectory().resolve(checksum.getResolvedName(context, algorithm));
                if (!Files.exists(checksums, new LinkOption[0])) continue;
                assets.add(Asset.checksum(Artifact.of(checksums)));
            }
        }
        if ((signing = context.getModel().getSigning()).isEnabled() && service.isSignatures().booleanValue()) {
            boolean signaturesAdded = false;
            ArrayList assetsCopy = new ArrayList(assets);
            for (Asset asset : assetsCopy) {
                Path signature;
                if (asset.getArtifact().extraPropertyIsTrue("skipSigning") || asset.getArtifact().extraPropertyIsTrue("skipReleaseSignatures") || !Files.exists(signature = context.getSignaturesDirectory().resolve(asset.getFilename() + signing.getSignatureExtension()), new LinkOption[0])) continue;
                assets.add(Asset.signature(Artifact.of(signature)));
                signaturesAdded = true;
            }
            if (signaturesAdded && signing.getMode() == Signing.Mode.COSIGN) {
                Path path = signing.getCosign().getResolvedPublicKeyFilePath(context);
                assets.add(Asset.signature(Artifact.of(path)));
            }
        }
        assets.forEach(this::addReleaseAsset);
        return this;
    }

    private boolean isIndividual(JReleaserContext context, Artifact artifact) {
        if (artifact.getExtraProperties().containsKey("individualChecksum")) {
            return StringUtils.isTrue((Object)artifact.getExtraProperties().get("individualChecksum"));
        }
        return context.getModel().getChecksum().isIndividual();
    }

    private boolean isIndividual(JReleaserContext context, Distribution distribution, Artifact artifact) {
        if (artifact.getExtraProperties().containsKey("individualChecksum")) {
            return StringUtils.isTrue((Object)artifact.getExtraProperties().get("individualChecksum"));
        }
        if (distribution.getExtraProperties().containsKey("individualChecksum")) {
            return StringUtils.isTrue((Object)distribution.getExtraProperties().get("individualChecksum"));
        }
        return context.getModel().getChecksum().isIndividual();
    }
}

