/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMember;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.impl.LazyValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.stream.Stream;

public class FieldScope
extends MemberScope<ResolvedField, Field> {
    private final LazyValue<MethodScope> getter = new LazyValue<MethodScope>(this::doFindGetter);

    protected FieldScope(ResolvedField field, ResolvedTypeWithMembers declaringTypeMembers, TypeContext context) {
        this(field, (ResolvedType)null, (String)null, declaringTypeMembers, false, context);
    }

    protected FieldScope(ResolvedField field, ResolvedType overriddenType, String overriddenName, ResolvedTypeWithMembers declaringTypeMembers, boolean fakeContainerItemScope, TypeContext context) {
        super(field, overriddenType, overriddenName, declaringTypeMembers, fakeContainerItemScope, context);
    }

    public FieldScope withOverriddenType(ResolvedType overriddenType) {
        return new FieldScope((ResolvedField)this.getMember(), overriddenType, this.getOverriddenName(), this.getDeclaringTypeMembers(), this.isFakeContainerItemScope(), this.getContext());
    }

    public FieldScope withOverriddenName(String overriddenName) {
        return new FieldScope((ResolvedField)this.getMember(), this.getOverriddenType(), overriddenName, this.getDeclaringTypeMembers(), this.isFakeContainerItemScope(), this.getContext());
    }

    public FieldScope asFakeContainerItemScope() {
        return (FieldScope)super.asFakeContainerItemScope();
    }

    @Override
    protected String doGetSchemaPropertyName() {
        return this.getName();
    }

    public boolean isTransient() {
        return ((ResolvedField)this.getMember()).isTransient();
    }

    public MethodScope findGetter() {
        return this.getter.get();
    }

    private MethodScope doFindGetter() {
        String capitalisedFieldName = this.getName().substring(0, 1).toUpperCase() + this.getName().substring(1);
        String getterName1 = "get" + capitalisedFieldName;
        String getterName2 = "is" + capitalisedFieldName;
        ResolvedMethod[] methods = this.getDeclaringTypeMembers().getMemberMethods();
        return Stream.of(methods).filter(method -> ((Method)method.getRawMember()).getParameterCount() == 0).filter(ResolvedMember::isPublic).filter(method -> method.getName().equals(getterName1) || method.getName().equals(getterName2)).findFirst().map(method -> this.getContext().createMethodScope((ResolvedMethod)method, this.getDeclaringTypeMembers())).orElse(null);
    }

    public boolean hasGetter() {
        return this.findGetter() != null;
    }

    @Override
    public <A extends Annotation> A getContainerItemAnnotation(Class<A> annotationClass) {
        AnnotatedType[] typeArguments;
        AnnotatedType annotatedType = ((Field)this.getRawMember()).getAnnotatedType();
        if (annotatedType instanceof AnnotatedParameterizedType && (typeArguments = ((AnnotatedParameterizedType)annotatedType).getAnnotatedActualTypeArguments()).length == 1) {
            return typeArguments[0].getAnnotation(annotationClass);
        }
        return null;
    }

    @Override
    public <A extends Annotation> A getAnnotationConsideringFieldAndGetter(Class<A> annotationClass) {
        A annotation = this.getAnnotation(annotationClass);
        if (annotation == null) {
            MethodScope associatedGetter = this.findGetter();
            annotation = associatedGetter == null ? null : ((MemberScope)associatedGetter).getAnnotation(annotationClass);
        }
        return annotation;
    }

    @Override
    public <A extends Annotation> A getContainerItemAnnotationConsideringFieldAndGetter(Class<A> annotationClass) {
        A annotation = this.getContainerItemAnnotation(annotationClass);
        if (annotation == null) {
            MethodScope associatedGetter = this.findGetter();
            annotation = associatedGetter == null ? null : ((MemberScope)associatedGetter).getContainerItemAnnotation(annotationClass);
        }
        return annotation;
    }
}

