/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Version;

public class CalVer
implements Version<CalVer> {
    private static final Map<String, String> PATTERNS = new LinkedHashMap<String, String>();
    private static final String YEAR = "YEAR";
    private static final String YEAR_LONG = "YYYY";
    private static final String YEAR_SHORT = "YY";
    private static final String YEAR_ZERO = "0Y";
    private static final String MONTH = "MONTH";
    private static final String MONTH_SHORT = "MM";
    private static final String MONTH_ZERO = "0M";
    private static final String WEEK = "WEEK";
    private static final String WEEK_SHORT = "WW";
    private static final String WEEK_ZERO = "0W";
    private static final String DAY = "DAY";
    private static final String DAY_SHORT = "DD";
    private static final String DAY_ZERO = "0D";
    private static final String MINOR = "MINOR";
    private static final String MICRO = "MICRO";
    private static final String MODIFIER = "MODIFIER";
    private static final String MODIFIER_OP = "[MODIFIER]";
    private static final String MODIFIER_OP2 = "MODIFIER]";
    private static final String[] YEARS = new String[]{"0Y", "YY", "YYYY"};
    private static final String[] MONTHS = new String[]{"0M", "MM"};
    private static final String[] WEEKS = new String[]{"0W", "WW"};
    private static final String[] DAYS = new String[]{"0D", "DD"};
    private static final String[] NUMBERS = new String[]{"MICRO", "MINOR"};
    private final String year;
    private final String month;
    private final String week;
    private final String day;
    private final String minor;
    private final String micro;
    private final String modifier;
    private final String pattern;
    private final int yearAsInt;
    private final int monthAsInt;
    private final int weekAsInt;
    private final int dayAsInt;
    private final int minorAsInt;
    private final int microAsInt;

    public CalVer(String pattern, Map<String, String> elements) {
        String y = elements.get(YEAR);
        String m = elements.get(MONTH);
        String w = elements.get(WEEK);
        String d = elements.get(DAY);
        String n = elements.get(MINOR);
        String r = elements.get(MICRO);
        String o = elements.get(MODIFIER);
        this.pattern = pattern;
        this.year = StringUtils.isNotBlank(y) ? y.trim() : null;
        this.month = StringUtils.isNotBlank(m) ? m.trim() : null;
        this.week = StringUtils.isNotBlank(w) ? w.trim() : null;
        this.day = StringUtils.isNotBlank(d) ? d.trim() : null;
        this.minor = StringUtils.isNotBlank(n) ? n.trim() : null;
        this.micro = StringUtils.isNotBlank(r) ? r.trim() : null;
        this.modifier = StringUtils.isNotBlank(o) ? o.trim() : null;
        this.yearAsInt = StringUtils.isBlank(this.year) ? -1 : CalVer.parseInt(this.year);
        this.monthAsInt = StringUtils.isBlank(this.month) ? -1 : CalVer.parseInt(this.month);
        this.weekAsInt = StringUtils.isBlank(this.week) ? -1 : CalVer.parseInt(this.week);
        this.dayAsInt = StringUtils.isBlank(this.day) ? -1 : CalVer.parseInt(this.day);
        this.minorAsInt = StringUtils.isBlank(this.minor) ? -1 : CalVer.parseInt(this.minor);
        int n2 = this.microAsInt = StringUtils.isBlank(this.micro) ? -1 : CalVer.parseInt(this.micro);
        if (this.yearAsInt != -1 && this.monthAsInt != -1 && this.dayAsInt != -1 && this.dayAsInt > YearMonth.of(this.yearAsInt, this.monthAsInt).lengthOfMonth()) {
            throw new IllegalArgumentException(RB.$("ERROR_version_parse", this));
        }
    }

    public boolean hasYear() {
        return StringUtils.isNotBlank(this.year);
    }

    public boolean hasMonth() {
        return StringUtils.isNotBlank(this.month);
    }

    public boolean hasWeek() {
        return StringUtils.isNotBlank(this.week);
    }

    public boolean hasDay() {
        return StringUtils.isNotBlank(this.day);
    }

    public boolean hasMinor() {
        return StringUtils.isNotBlank(this.minor);
    }

    public boolean hasMicro() {
        return StringUtils.isNotBlank(this.micro);
    }

    public boolean hasModifier() {
        return StringUtils.isNotBlank(this.modifier);
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getYear() {
        return this.year;
    }

    public String getMonth() {
        return this.month;
    }

    public String getWeek() {
        return this.week;
    }

    public String getDay() {
        return this.day;
    }

    public String getMinor() {
        return this.minor;
    }

    public String getMicro() {
        return this.micro;
    }

    public String getModifier() {
        return this.modifier;
    }

    public int getYearAsInt() {
        return this.yearAsInt;
    }

    public int getMonthAsInt() {
        return this.monthAsInt;
    }

    public int getWeekAsInt() {
        return this.weekAsInt;
    }

    public int getDayAsInt() {
        return this.dayAsInt;
    }

    public int getMinorAsInt() {
        return this.minorAsInt;
    }

    public int getMicroAsInt() {
        return this.microAsInt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalVer version = (CalVer)o;
        return Objects.equals(this.pattern, version.pattern) && Objects.equals(this.year, version.year) && Objects.equals(this.month, version.month) && Objects.equals(this.week, version.week) && Objects.equals(this.day, version.day) && Objects.equals(this.minor, version.minor) && Objects.equals(this.micro, version.micro) && Objects.equals(this.modifier, version.modifier);
    }

    @Override
    public String toRpmVersion() {
        return this.toString().replace("-", "_");
    }

    public String toString() {
        return this.pattern.replace(YEAR_LONG, this.year).replace(YEAR_SHORT, this.year).replace(YEAR_ZERO, this.year).replace(MONTH_SHORT, this.month).replace(MONTH_ZERO, this.month).replace(WEEK_SHORT, this.week).replace(WEEK_ZERO, this.week).replace(DAY_SHORT, this.day).replace(DAY_ZERO, this.day).replace(MINOR, String.valueOf(this.minor)).replace(MICRO, String.valueOf(this.micro)).replace(MODIFIER, this.modifier);
    }

    public int hashCode() {
        return Objects.hash(this.pattern, this.year, this.month, this.week, this.day, this.minor, this.micro, this.modifier);
    }

    @Override
    public int compareTo(CalVer other) {
        int result = this.pattern.compareTo(other.pattern);
        if (result == 0) {
            result = this.yearAsInt - other.yearAsInt;
        }
        if (result == 0) {
            int n = result = this.hasMonth() ? this.monthAsInt - other.monthAsInt : 0;
        }
        if (result == 0) {
            int n = result = this.hasWeek() ? this.weekAsInt - other.weekAsInt : 0;
        }
        if (result == 0) {
            int n = result = this.hasDay() ? this.dayAsInt - other.dayAsInt : 0;
        }
        if (result == 0) {
            int n = result = this.hasMinor() ? this.minorAsInt - other.minorAsInt : 0;
        }
        if (result == 0) {
            int n = result = this.hasMicro() ? this.microAsInt - other.microAsInt : 0;
        }
        if (result == 0 && StringUtils.isNotBlank(this.modifier)) {
            result = this.modifier.compareTo(other.modifier);
        }
        return result;
    }

    @Override
    public boolean equalsSpec(CalVer version) {
        return this.pattern.equals(version.pattern);
    }

    private static int parseInt(String str) {
        if ("0".equals(str)) {
            return 0;
        }
        if (str.startsWith("0")) {
            return Integer.parseInt(str.substring(1));
        }
        return Integer.parseInt(str);
    }

    public static CalVer of(String format, String version) {
        Pattern pattern;
        Matcher matcher;
        StringUtils.requireNonBlank(format, "Argument 'format' must not be blank");
        StringUtils.requireNonBlank(version, "Argument 'version' must not be blank");
        ArrayList<String> tokens = new ArrayList<String>();
        List<Character> delims = CollectionUtils.newList(Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('-'), Character.valueOf('['));
        String f = format.trim();
        String y = null;
        String m = null;
        String w = null;
        String d = null;
        String n = null;
        String r = null;
        String o = null;
        int i = 0;
        Tuple s = CalVer.take(f, i, delims);
        if (Arrays.binarySearch(YEARS, s.token) < 0) {
            throw new IllegalArgumentException(RB.$("ERROR_calver_year", f));
        }
        y = s.token;
        tokens.add(y);
        if (StringUtils.isNotBlank(s.sep)) {
            tokens.add(s.sep);
        }
        if (Arrays.binarySearch(MONTHS, (s = CalVer.take(f, i = y.length() + 1, delims)).token) >= 0) {
            if (f.contains(WEEK_ZERO) || f.contains(WEEK_SHORT)) {
                throw new IllegalArgumentException(RB.$("ERROR_calver_month", f));
            }
            m = s.token;
            tokens.add(m);
            if (StringUtils.isNotBlank(s.sep)) {
                tokens.add(s.sep);
            }
            if (Arrays.binarySearch(DAYS, (s = CalVer.take(f, i += m.length() + 1, delims)).token) >= 0) {
                d = s.token;
                tokens.add(d);
                if (StringUtils.isNotBlank(s.sep)) {
                    tokens.add(s.sep);
                }
                s = CalVer.take(f, i += d.length() + 1, delims);
            }
        } else if (Arrays.binarySearch(WEEKS, s.token) >= 0) {
            if (f.contains(MONTH_ZERO) || f.contains(MONTH_SHORT)) {
                throw new IllegalArgumentException(RB.$("ERROR_calver_week_month", f));
            }
            if (f.contains(DAY_ZERO) || f.contains(DAY_SHORT)) {
                throw new IllegalArgumentException(RB.$("ERROR_calver_week_day", f));
            }
            w = s.token;
            tokens.add(w);
            if (StringUtils.isNotBlank(s.sep)) {
                tokens.add(s.sep);
            }
            s = CalVer.take(f, i += w.length() + 1, delims);
        }
        boolean micro = false;
        boolean done = false;
        if (Arrays.binarySearch(NUMBERS, s.token) >= 0) {
            tokens.add(s.token);
            if (StringUtils.isNotBlank(s.sep)) {
                tokens.add(s.sep);
            }
            i += s.token.length() + 1;
            micro = MICRO.equals(s.token);
            n = !micro ? s.token : null;
            r = micro ? s.token : null;
            s = CalVer.take(f, i, delims);
            done = StringUtils.isBlank(s.token);
        } else {
            s = CalVer.take(f, i, Collections.emptyList());
            o = s.token;
            if (StringUtils.isNotBlank(o)) {
                tokens.add(o);
            }
            done = true;
        }
        if (!done) {
            if (Arrays.binarySearch(NUMBERS, s.token) >= 0) {
                if (micro) {
                    if (MICRO.equals(s.token)) {
                        throw new IllegalArgumentException(RB.$("ERROR_calver_micro_duplicate", f));
                    }
                    throw new IllegalArgumentException(RB.$("ERROR_calver_micro_minor", f));
                }
                if (MINOR.equals(s.token)) {
                    throw new IllegalArgumentException(RB.$("ERROR_calver_minor_duplicate", f));
                }
                tokens.add(s.token);
                if (StringUtils.isNotBlank(s.sep)) {
                    tokens.add(s.sep);
                }
                if (StringUtils.isNotBlank(o = (s = CalVer.take(f, i += (r = s.token).length() + 1, Collections.emptyList())).token)) {
                    tokens.add(o);
                }
            } else {
                s = CalVer.take(f, i, Collections.emptyList());
                o = s.token;
                if (StringUtils.isNotBlank(o)) {
                    tokens.add(o);
                }
            }
        }
        if (tokens.size() > 0 && ((String)tokens.get(tokens.size() - 1)).endsWith(MODIFIER_OP2)) {
            String sep = (String)tokens.remove(tokens.size() - 2);
            String mod = "(?:" + sep + PATTERNS.get(MODIFIER_OP);
            tokens.set(tokens.size() - 1, mod);
        }
        if ((matcher = (pattern = Pattern.compile("^" + tokens.stream().map(t -> PATTERNS.getOrDefault(t, (String)t)).collect(Collectors.joining("")) + "$")).matcher(version.trim())).matches()) {
            i = 1;
            LinkedHashMap<String, String> elements = new LinkedHashMap<String, String>();
            elements.put(YEAR, matcher.group(i++));
            if (StringUtils.isNotBlank(w)) {
                elements.put(WEEK, matcher.group(i++));
            }
            if (StringUtils.isNotBlank(m)) {
                elements.put(MONTH, matcher.group(i++));
            }
            if (StringUtils.isNotBlank(d)) {
                elements.put(DAY, matcher.group(i++));
            }
            if (StringUtils.isNotBlank(n)) {
                elements.put(MINOR, matcher.group(i++));
            }
            if (StringUtils.isNotBlank(r)) {
                elements.put(MICRO, matcher.group(i++));
            }
            if (i <= matcher.groupCount()) {
                elements.put(MODIFIER, matcher.group(matcher.groupCount()));
            }
            return new CalVer(format, elements);
        }
        throw new IllegalArgumentException(RB.$("ERROR_version_parse_with", version, f));
    }

    public static CalVer defaultFor(String format) {
        StringUtils.requireNonBlank(format, "Argument 'format' must not be blank");
        return CalVer.of(format, format.replace(YEAR_LONG, "2000").replace(YEAR_SHORT, "0").replace(YEAR_ZERO, "0").replace(MONTH_SHORT, "1").replace(MONTH_ZERO, "01").replace(WEEK_SHORT, "1").replace(WEEK_ZERO, "01").replace(DAY_SHORT, "1").replace(DAY_ZERO, "01").replace(MINOR, "0").replace(MICRO, "0").replace(MODIFIER, "A"));
    }

    private static Tuple take(String str, int index, List<Character> delims) {
        StringBuilder b = new StringBuilder();
        for (int i = index; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (delims.contains(Character.valueOf(c))) {
                if (c == '[' && str.length() > i + 1) {
                    c = str.charAt(i + 1);
                }
                return new Tuple(b.toString(), c);
            }
            b.append(c);
        }
        return new Tuple(b.toString(), '\u0000');
    }

    static {
        PATTERNS.put(YEAR_LONG, "([2-9][0-9]{3})");
        PATTERNS.put(YEAR_SHORT, "([1-9]|[1-9][0-9]|[1-9][0-9]{2})");
        PATTERNS.put(YEAR_ZERO, "(0[1-9]|[1-9][0-9]|[1-9][0-9]{2})");
        PATTERNS.put(MONTH_SHORT, "([1-9]|1[0-2])");
        PATTERNS.put(MONTH_ZERO, "(0[1-9]|1[0-2])");
        PATTERNS.put(WEEK_SHORT, "([1-9]|[1-4][0-9]|5[0-2])");
        PATTERNS.put(WEEK_ZERO, "(0[1-9]|[1-4][0-9]|5[0-2])");
        PATTERNS.put(DAY_SHORT, "([1-9]|[1-2][0-9]|3[0-1])");
        PATTERNS.put(DAY_ZERO, "(0[1-9]|[1-2][0-9]|3[0-1])");
        PATTERNS.put(MINOR, "(0|[1-9]\\d*)");
        PATTERNS.put(MICRO, "(0|[1-9]\\d*)");
        PATTERNS.put(MODIFIER, "([a-zA-Z\\-][0-9a-zA-Z\\-]*)");
        PATTERNS.put(MODIFIER_OP, "([a-zA-Z\\-][0-9a-zA-Z\\-]*))?");
    }

    private static class Tuple {
        private final String token;
        private final String sep;

        private Tuple(String token, char sep) {
            this.token = token;
            this.sep = sep != '\u0000' ? Tuple.escape(sep) : "";
        }

        private static String escape(char sep) {
            if ('.' == sep) {
                return "\\.";
            }
            return String.valueOf(sep);
        }
    }
}

