/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.github;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import feign.Client;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.httpclient.ApacheHttpClient;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.releaser.spi.User;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.github.api.GhRelease;
import org.jreleaser.sdk.github.api.GhSearchUser;
import org.jreleaser.sdk.github.api.GhUser;
import org.jreleaser.sdk.github.api.GithubAPI;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.StringUtils;

class XGithub {
    private final JReleaserLogger logger;
    private final GithubAPI api;

    XGithub(JReleaserLogger logger, String endpoint, String token, int connectTimeout, int readTimeout) throws IOException {
        Objects.requireNonNull(logger, "'logger' must not be null");
        StringUtils.requireNonBlank((String)token, (String)"'token' must not be blank");
        StringUtils.requireNonBlank((String)endpoint, (String)"'endpoint' must not be blank");
        ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.INDENT_OUTPUT, true);
        this.logger = logger;
        this.api = (GithubAPI)((Feign.Builder)((Feign.Builder)((Feign.Builder)ClientUtils.builder((JReleaserLogger)logger, (int)connectTimeout, (int)readTimeout).client((Client)new ApacheHttpClient()).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(objectMapper)))).decoder((Decoder)new JacksonDecoder(objectMapper))).requestInterceptor(template -> template.header("Authorization", new String[]{String.format("token %s", token)}))).target(GithubAPI.class, endpoint);
    }

    void updateRelease(String owner, String repo, String tag, Long id, GhRelease release) throws RestAPIException {
        this.logger.debug(RB.$((String)"git.update.release", (Object[])new Object[0]), new Object[]{owner, repo, tag});
        this.api.updateRelease(release, owner, repo, id);
    }

    Optional<User> findUser(String email, String name) throws RestAPIException {
        GhUser user;
        GhUser test;
        this.logger.debug(RB.$((String)"git.user.lookup", (Object[])new Object[0]), new Object[]{name, email});
        GhSearchUser search = this.api.searchUser(CollectionUtils.newMap((Object[])new Object[]{"q", email}));
        if (search.getTotalCount() > 0) {
            GhUser user2 = search.getItems().get(0);
            return Optional.of(new User(user2.getLogin(), email, user2.getHtmlUrl()));
        }
        String query = "fullname:" + name + " type:user";
        search = this.api.searchUser(CollectionUtils.newMap((Object[])new Object[]{"q", query}));
        if (search.getTotalCount() > 0 && name.equals((test = this.api.getUser((user = search.getItems().get(0)).getLogin())).getName())) {
            return Optional.of(new User(user.getLogin(), email, user.getHtmlUrl()));
        }
        return Optional.empty();
    }
}

