/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Activatable;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Domain;
import org.jreleaser.model.Glob;
import org.jreleaser.model.Project;
import org.jreleaser.util.Env;

public class Files
extends AbstractModelObject<Files>
implements Domain,
Activatable {
    private final Set<Artifact> artifacts = new LinkedHashSet<Artifact>();
    private final List<Glob> globs = new ArrayList<Glob>();
    @JsonIgnore
    private final Set<Artifact> paths = new LinkedHashSet<Artifact>();
    @JsonIgnore
    private boolean resolved;
    private Active active;
    @JsonIgnore
    private boolean enabled;

    @Override
    public void freeze() {
        super.freeze();
        this.artifacts.forEach(AbstractModelObject::freeze);
        this.globs.forEach(AbstractModelObject::freeze);
    }

    @Override
    public void merge(Files files) {
        this.freezeCheck();
        this.active = this.merge(this.active, files.active);
        this.enabled = this.merge(this.enabled, files.enabled);
        this.setArtifacts(this.merge(this.artifacts, files.artifacts));
        this.setGlobs(this.merge(this.globs, files.globs));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.setActive(Env.resolveOrDefault((String)"files.active", (String)"", (String)"NEVER"));
        }
        this.enabled = this.active.check(project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.freezeCheck();
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of(str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    public boolean isEmpty() {
        return this.artifacts.isEmpty() && this.globs.isEmpty();
    }

    public boolean arePathsResolved() {
        return this.resolved;
    }

    public Set<Artifact> getPaths() {
        return this.freezeWrap(Artifact.sortArtifacts(this.paths));
    }

    public void setPaths(Set<Artifact> paths) {
        this.freezeCheck();
        this.paths.clear();
        this.paths.addAll(paths);
        this.resolved = true;
    }

    public Set<Artifact> getArtifacts() {
        return this.freezeWrap(Artifact.sortArtifacts(this.artifacts));
    }

    public void setArtifacts(Set<Artifact> artifacts) {
        this.freezeCheck();
        this.artifacts.clear();
        this.artifacts.addAll(artifacts);
    }

    public void addArtifacts(Set<Artifact> artifacts) {
        this.freezeCheck();
        this.artifacts.addAll(artifacts);
    }

    public void addArtifact(Artifact artifact) {
        this.freezeCheck();
        if (null != artifact) {
            this.artifacts.add(artifact);
        }
    }

    public List<Glob> getGlobs() {
        return this.freezeWrap(this.globs);
    }

    public void setGlobs(List<Glob> globs) {
        this.freezeCheck();
        this.globs.clear();
        this.globs.addAll(globs);
    }

    public void addGlobs(List<Glob> globs) {
        this.freezeCheck();
        this.globs.addAll(globs);
    }

    public void addGlob(Glob glob) {
        this.freezeCheck();
        if (null != glob) {
            this.globs.add(glob);
        }
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", (Object)this.active);
        LinkedHashMap<String, Map<String, Object>> mappedArtifacts = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Artifact artifact : this.getArtifacts()) {
            mappedArtifacts.put("artifact " + i++, artifact.asMap(full));
        }
        map.put("artifacts", mappedArtifacts);
        LinkedHashMap<String, Map<String, Object>> mappedGlobs = new LinkedHashMap<String, Map<String, Object>>();
        for (i = 0; i < this.globs.size(); ++i) {
            mappedGlobs.put("glob " + i, this.globs.get(i).asMap(full));
        }
        map.put("globs", mappedGlobs);
        return map;
    }
}

