/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Codeberg;
import org.jreleaser.model.Domain;
import org.jreleaser.model.GenericGit;
import org.jreleaser.model.GitService;
import org.jreleaser.model.Gitea;
import org.jreleaser.model.Github;
import org.jreleaser.model.Gitlab;

public class Release
extends AbstractModelObject<Release>
implements Domain {
    private Github github;
    private Gitlab gitlab;
    private Gitea gitea;
    private Codeberg codeberg;
    private GenericGit generic;

    @Override
    public void freeze() {
        super.freeze();
        if (null != this.github) {
            this.github.freeze();
        }
        if (null != this.gitlab) {
            this.gitlab.freeze();
        }
        if (null != this.gitea) {
            this.gitea.freeze();
        }
        if (null != this.codeberg) {
            this.codeberg.freeze();
        }
        if (null != this.generic) {
            this.generic.freeze();
        }
    }

    @Override
    public void merge(Release release) {
        this.freezeCheck();
        this.github = this.merge(this.github, release.github);
        this.gitlab = this.merge(this.gitlab, release.gitlab);
        this.gitea = this.merge(this.gitea, release.gitea);
        this.codeberg = this.merge(this.codeberg, release.codeberg);
        this.generic = this.merge(this.generic, release.generic);
    }

    public Github getGithub() {
        return this.github;
    }

    public void setGithub(Github github) {
        this.freezeCheck();
        this.github = github;
    }

    public Gitlab getGitlab() {
        return this.gitlab;
    }

    public void setGitlab(Gitlab gitlab) {
        this.freezeCheck();
        this.gitlab = gitlab;
    }

    public Gitea getGitea() {
        return this.gitea;
    }

    public void setGitea(Gitea gitea) {
        this.freezeCheck();
        this.gitea = gitea;
    }

    public Codeberg getCodeberg() {
        return this.codeberg;
    }

    public void setCodeberg(Codeberg codeberg) {
        this.freezeCheck();
        this.codeberg = codeberg;
    }

    public GenericGit getGeneric() {
        return this.generic;
    }

    public void setGeneric(GenericGit generic) {
        this.freezeCheck();
        this.generic = generic;
    }

    public GitService getGitService() {
        if (null != this.github) {
            return this.github;
        }
        if (null != this.gitlab) {
            return this.gitlab;
        }
        if (null != this.gitea) {
            return this.gitea;
        }
        if (null != this.codeberg) {
            return this.codeberg;
        }
        return this.generic;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (null != this.github) {
            map.put("github", this.github.asMap(full));
        }
        if (null != this.gitlab) {
            map.put("gitlab", this.gitlab.asMap(full));
        }
        if (null != this.gitea) {
            map.put("gitea", this.gitea.asMap(full));
        }
        if (null != this.codeberg) {
            map.put("codeberg", this.codeberg.asMap(full));
        }
        if (null != this.generic) {
            map.put("generic", this.generic.asMap(full));
        }
        return map;
    }
}

