/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.ScpUploader;
import org.jreleaser.model.validation.SshValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class ScpUploaderValidator
extends Validator {
    public static void validateScpUploader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("scp");
        Map<String, ScpUploader> scp = context.getModel().getUpload().getScp();
        for (Map.Entry<String, ScpUploader> e : scp.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) {
                ScpUploaderValidator.validateScpUploader(context, mode, e.getValue(), new Errors());
                continue;
            }
            ScpUploaderValidator.validateScpUploader(context, mode, e.getValue(), errors);
        }
    }

    private static void validateScpUploader(JReleaserContext context, JReleaserContext.Mode mode, ScpUploader scp, Errors errors) {
        context.getLogger().debug("scp.{}", new Object[]{scp.getName()});
        if (!scp.isActiveSet()) {
            scp.setActive(Active.NEVER);
        }
        if (!scp.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        if (!(scp.isArtifacts().booleanValue() || scp.isFiles().booleanValue() || scp.isSignatures().booleanValue())) {
            scp.disable();
            return;
        }
        SshValidator.validateSsh(context, scp, scp.getName(), "SCP", scp.getType(), errors);
        if (StringUtils.isBlank((String)scp.getPath())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"scp." + scp.getName() + ".path"}));
        }
        ScpUploaderValidator.validateTimeout(scp);
    }
}

