/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider.pkcs;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Objects;
import net.schmizz.sshj.userauth.keyprovider.pkcs.KeyPairConverter;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.openssl.PEMKeyPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ECDSAPrivateKeyInfoKeyPairConverter
implements KeyPairConverter<PrivateKeyInfo> {
    private static final Logger logger = LoggerFactory.getLogger(ECDSAPrivateKeyInfoKeyPairConverter.class);
    private static final boolean POINT_COMPRESSED = false;

    ECDSAPrivateKeyInfoKeyPairConverter() {
    }

    @Override
    public PEMKeyPair getKeyPair(PrivateKeyInfo privateKeyInfo) throws IOException {
        Objects.requireNonNull(privateKeyInfo, "Private Key Info required");
        AlgorithmIdentifier algorithmIdentifier = privateKeyInfo.getPrivateKeyAlgorithm();
        ASN1ObjectIdentifier algorithm = algorithmIdentifier.getAlgorithm();
        if (!X9ObjectIdentifiers.id_ecPublicKey.equals((ASN1Primitive)algorithm)) {
            throw new IllegalArgumentException(String.format("ECDSA Algorithm OID required [%s]", algorithm));
        }
        logger.debug("ECDSA Algorithm Found [{}]", (Object)algorithm);
        byte[] encodedPublicKey = this.getEncodedPublicKey(privateKeyInfo);
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, encodedPublicKey);
        return new PEMKeyPair(subjectPublicKeyInfo, privateKeyInfo);
    }

    private byte[] getEncodedPublicKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        X9ECParameters parameters = this.getParameters(privateKeyInfo.getPrivateKeyAlgorithm());
        ECPrivateKey ecPrivateKey = ECPrivateKey.getInstance((Object)privateKeyInfo.parsePrivateKey());
        ECPoint publicKey = this.getPublicKey(parameters, ecPrivateKey.getKey());
        return publicKey.getEncoded(false);
    }

    private X9ECParameters getParameters(AlgorithmIdentifier algorithmIdentifier) {
        ASN1ObjectIdentifier encodedParameters = ASN1ObjectIdentifier.getInstance((Object)algorithmIdentifier.getParameters());
        return ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)encodedParameters);
    }

    private ECPoint getPublicKey(X9ECParameters parameters, BigInteger privateKey) {
        FixedPointCombMultiplier multiplier = new FixedPointCombMultiplier();
        return multiplier.multiply(parameters.getG(), privateKey);
    }
}

