/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.compress.utils.IOUtils;
import org.jreleaser.assemblers.AbstractJavaAssemblerProcessor;
import org.jreleaser.assemblers.AssemblerUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Assembler;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JavaAssembler;
import org.jreleaser.model.Jpackage;
import org.jreleaser.model.Project;
import org.jreleaser.model.assembler.spi.AssemblerProcessingException;
import org.jreleaser.templates.TemplateResource;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.SemVer;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;
import org.jreleaser.util.command.Command;

public class JpackageAssemblerProcessor
extends AbstractJavaAssemblerProcessor<Jpackage> {
    public JpackageAssemblerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doAssemble(Map<String, Object> props) throws AssemblerProcessingException {
        Jpackage.PlatformPackager packager = ((Jpackage)this.assembler).getResolvedPlatformPackager();
        Path jdkPath = packager.getJdk().getEffectivePath(this.context, this.assembler);
        SemVer jdkVersion = SemVer.of((String)AssemblerUtils.readJavaVersion(jdkPath));
        this.context.getLogger().debug(RB.$((String)"assembler.jpackage.jdk", (Object[])new Object[0]), new Object[]{jdkVersion, jdkPath.toAbsolutePath().toString()});
        if (jdkVersion.getMajor() < 16) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_jpackage_minimum_jdk_required", (Object[])new Object[]{jdkVersion.toString()}));
        }
        String platform = packager.getJdk().getPlatform();
        Path assembleDirectory = (Path)props.get("distributionAssembleDirectory");
        Path workDirectory = assembleDirectory.resolve("work-" + platform);
        Path inputsDirectory = workDirectory.resolve("inputs");
        Path filesDirectory = inputsDirectory.resolve("files");
        this.copyFiles(this.context, filesDirectory);
        this.copyFileSets(this.context, filesDirectory);
        this.context.getLogger().debug(RB.$((String)"assembler.copy.jars", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(filesDirectory)});
        AssemblerUtils.copyJars(this.context, (JavaAssembler)this.assembler, filesDirectory, "");
        AssemblerUtils.copyJars(this.context, (JavaAssembler)this.assembler, filesDirectory, platform);
        this.copyIcon(this.context, (Jpackage)this.assembler, packager, inputsDirectory, platform, props);
        if (StringUtils.isNotBlank((String)((Jpackage)this.assembler).getJlink())) {
            this.adjustRuntimeImage(this.context, (Jpackage)this.assembler, workDirectory, platform);
        }
        for (String type : packager.getTypes()) {
            this.context.getLogger().info("- " + RB.$((String)"assembler.jpackage.type", (Object[])new Object[0]), new Object[]{type});
            this.jpackage(this.context, type, workDirectory, props);
        }
    }

    private void copyIcon(JReleaserContext context, Jpackage assembler, Jpackage.PlatformPackager packager, Path inputsDirectory, String platform, Map<String, Object> props) throws AssemblerProcessingException {
        block12: {
            String p = "linux";
            String ext = ".png";
            if (PlatformUtils.isWindows((String)platform)) {
                p = "windows";
                ext = ".ico";
            } else if (PlatformUtils.isMac((String)platform)) {
                p = "osx";
                ext = ".icns";
            }
            String icon = Templates.resolveTemplate((String)packager.getIcon(), props);
            try {
                if (StringUtils.isNotBlank((String)icon) && Files.exists(context.getBasedir().resolve(icon), new LinkOption[0]) && icon.endsWith(ext)) {
                    Path iconPath = context.getBasedir().resolve(icon);
                    Files.copy(iconPath, inputsDirectory.resolve(assembler.getName() + ext), StandardCopyOption.REPLACE_EXISTING);
                    break block12;
                }
                String iconResource = "META-INF/jreleaser/icons/" + p + "/duke" + ext;
                try (TemplateResource templateResource = TemplateUtils.resolveResource((JReleaserLogger)context.getLogger(), (String)iconResource);){
                    this.writeFile(IOUtils.toByteArray((InputStream)templateResource.getInputStream()), inputsDirectory.resolve(assembler.getName() + ext));
                }
            }
            catch (Exception e) {
                throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    private void adjustRuntimeImage(final JReleaserContext context, final Jpackage assembler, Path workDirectory, String platform) throws AssemblerProcessingException {
        Optional runtimeImageByPlatform = assembler.findRuntimeImageByPlatform(platform);
        if (!runtimeImageByPlatform.isPresent()) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_jpackage_runtime_image_not_found", (Object[])new Object[]{platform}));
        }
        Path originalImage = ((Artifact)runtimeImageByPlatform.get()).getEffectivePath(context, (Assembler)assembler);
        Path adjustedImage = workDirectory.resolve("runtime-image");
        try {
            if (!FileUtils.copyFilesRecursive((JReleaserLogger)context.getLogger(), (Path)originalImage, (Path)adjustedImage, (Predicate)new Predicate<Path>(){

                @Override
                public boolean test(Path path) {
                    boolean pathIsJar = path.getFileName().toString().endsWith(".jar") && path.getParent().getFileName().toString().equals("jars");
                    boolean pathIsExecutable = path.getFileName().toString().equals(context.getModel().getAssemble().findJlink(assembler.getJlink()).getExecutable());
                    return pathIsJar || pathIsExecutable;
                }
            })) {
                throw new IOException(RB.$((String)"ERROR_assembler_adjusting_image", (Object[])new Object[]{adjustedImage}));
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
        ((Artifact)runtimeImageByPlatform.get()).setPath(adjustedImage.toAbsolutePath().toString());
    }

    private void jpackage(JReleaserContext context, String type, Path workDirectory, Map<String, Object> props) throws AssemblerProcessingException {
        Object licenseFilePath;
        Jpackage.PlatformPackager packager = ((Jpackage)this.assembler).getResolvedPlatformPackager();
        Path jdkPath = packager.getJdk().getEffectivePath(context, this.assembler);
        String platform = packager.getJdk().getPlatform();
        String platformReplaced = ((Jpackage)this.assembler).getPlatform().applyReplacements(platform);
        Path assembleDirectory = workDirectory.getParent();
        Path packagerDirectory = workDirectory.resolve(type).toAbsolutePath();
        try {
            FileUtils.deleteFiles((Path)packagerDirectory);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_delete_dir", (Object[])new Object[]{context.relativizeToBasedir(packagerDirectory)}), (Throwable)e);
        }
        Path inputsDirectory = workDirectory.resolve("inputs");
        Optional runtimeImageByPlatform = ((Jpackage)this.assembler).findRuntimeImageByPlatform(platform);
        if (!runtimeImageByPlatform.isPresent()) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_jpackage_runtime_image_not_found", (Object[])new Object[]{platform}));
        }
        String moduleName = ((Jpackage)this.assembler).getJava().getMainModule();
        String appName = packager.getResolvedAppName(context, (Jpackage)this.assembler);
        String appVersion = ((Jpackage)this.assembler).getApplicationPackage().getResolvedAppVersion(context, (Jpackage)this.assembler);
        String vendor = ((Jpackage)this.assembler).getApplicationPackage().getVendor();
        String copyright = ((Jpackage)this.assembler).getApplicationPackage().getCopyright();
        Path jpackageExecutable = jdkPath.resolve("bin").resolve(PlatformUtils.isWindows() ? "jpackage.exe" : "jpackage").toAbsolutePath();
        Command cmd = new Command(jpackageExecutable.toAbsolutePath().toString(), true).arg("--type").arg(type).arg("--dest").arg(assembleDirectory.toAbsolutePath().toString()).arg("--input").arg(inputsDirectory.resolve("files").toAbsolutePath().toString()).arg("--name").arg(this.maybeQuote(appName)).arg("--runtime-image").arg(this.maybeQuote(((Artifact)runtimeImageByPlatform.get()).getEffectivePath(context, this.assembler).toAbsolutePath().toString())).arg("--app-version").arg(appVersion).arg("--vendor").arg(this.maybeQuote(vendor)).arg("--copyright").arg(this.maybeQuote(copyright)).arg("--description").arg(this.maybeQuote(context.getModel().getProject().getDescription()));
        if (((Jpackage)this.assembler).isVerbose()) {
            cmd.arg("--verbose");
        }
        if (StringUtils.isNotBlank((String)moduleName)) {
            cmd.arg("--module").arg(moduleName + "/" + ((Jpackage)this.assembler).getJava().getMainClass());
        } else {
            cmd.arg("--main-class").arg(((Jpackage)this.assembler).getJava().getMainClass()).arg("--main-jar").arg(this.maybeQuote(((Jpackage)this.assembler).getMainJar().getResolvedPath().getFileName().toString()));
        }
        for (String argument : ((Jpackage)this.assembler).getLauncher().getArguments()) {
            cmd.arg("--arguments").arg(this.maybeQuote(argument));
        }
        for (String javaOption : ((Jpackage)this.assembler).getLauncher().getJavaOptions()) {
            cmd.arg("--java-options").arg(this.maybeQuote(javaOption));
        }
        for (String launcher : ((Jpackage)this.assembler).getLauncher().getLaunchers()) {
            cmd.arg("--add-launcher").arg(this.maybeQuote(launcher));
        }
        String licenseFile = Templates.resolveTemplate((String)((Jpackage)this.assembler).getApplicationPackage().getLicenseFile(), props);
        if (StringUtils.isNotBlank((String)licenseFile) && Files.exists((Path)(licenseFilePath = context.getBasedir().resolve(licenseFile)), new LinkOption[0])) {
            cmd.arg("--license-file").arg(this.maybeQuote(licenseFilePath.toAbsolutePath().toString()));
        }
        if (!((Jpackage)this.assembler).getApplicationPackage().getFileAssociations().isEmpty()) {
            for (String filename : ((Jpackage)this.assembler).getApplicationPackage().getFileAssociations()) {
                Path path = context.getBasedir().resolve(Templates.resolveTemplate((String)filename, props));
                if (!Files.exists(path, new LinkOption[0])) continue;
                cmd.arg("--file-associations").arg(this.maybeQuote(path.toAbsolutePath().toString()));
            }
        }
        this.customize(type, packager, inputsDirectory, cmd, props);
        context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.executeCommandCapturing(cmd, out);
        if (((Jpackage)this.assembler).isVerbose()) {
            context.getLogger().debug(out.toString());
        }
        if (!PlatformUtils.isLinux((String)platform) && ((Jpackage)this.assembler).isAttachPlatform()) {
            try {
                Optional artifact = (Optional)FileUtils.listFilesAndProcess((Path)assembleDirectory, files -> files.filter(path -> path.getFileName().toString().endsWith(type)).findFirst());
                if (artifact.isPresent()) {
                    String dest = ((Path)artifact.get()).getFileName().toString().replace("." + type, "-" + platformReplaced + "." + type);
                    Files.move(assembleDirectory.resolve(((Path)artifact.get()).getFileName()), assembleDirectory.resolve(dest), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException e) {
                throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    private void customize(String type, Jpackage.PlatformPackager packager, Path inputsDirectory, Command cmd, Map<String, Object> props) {
        Path resourceDirPath;
        String resourceDir;
        String installDir = Templates.resolveTemplate((String)packager.getInstallDir(), props);
        if (StringUtils.isNotBlank((String)installDir)) {
            cmd.arg("--install-dir").arg(this.maybeQuote(installDir));
        }
        if (StringUtils.isNotBlank((String)(resourceDir = Templates.resolveTemplate((String)packager.getResourceDir(), props))) && Files.exists(resourceDirPath = this.context.getBasedir().resolve(resourceDir), new LinkOption[0])) {
            cmd.arg("--resource-dir").arg(this.maybeQuote(resourceDirPath.toAbsolutePath().toString()));
        }
        if (packager instanceof Jpackage.Osx) {
            this.customizeOsx(type, (Jpackage.Osx)packager, inputsDirectory, cmd, props);
        } else if (packager instanceof Jpackage.Linux) {
            this.customizeLinux(type, (Jpackage.Linux)packager, inputsDirectory, cmd, props);
        } else if (packager instanceof Jpackage.Windows) {
            this.customizeWindows(type, (Jpackage.Windows)packager, inputsDirectory, cmd, props);
        }
    }

    private void customizeOsx(String type, Jpackage.Osx packager, Path inputsDirectory, Command cmd, Map<String, Object> props) {
        Path path;
        String signingKeychain;
        if (StringUtils.isNotBlank((String)packager.getPackageName())) {
            cmd.arg("--mac-package-name").arg(packager.getPackageName());
        }
        if (StringUtils.isNotBlank((String)packager.getPackageSigningPrefix())) {
            cmd.arg("--mac-package-signing-prefix").arg(packager.getPackageSigningPrefix());
        }
        if (packager.isSign()) {
            cmd.arg("--mac-sign");
        }
        if (StringUtils.isNotBlank((String)(signingKeychain = Templates.resolveTemplate((String)packager.getSigningKeychain(), props))) && Files.exists(path = this.context.getBasedir().resolve(Templates.resolveTemplate((String)signingKeychain, props)), new LinkOption[0])) {
            cmd.arg("--mac-signing-keychain").arg(path.toAbsolutePath().toString());
        }
        if (StringUtils.isNotBlank((String)packager.getSigningKeyUsername())) {
            cmd.arg("--mac-signing-key-user-name").arg(packager.getSigningKeyUsername());
        }
        cmd.arg("--icon").arg(inputsDirectory.resolve(((Jpackage)this.assembler).getName() + ".icns").toAbsolutePath().toString());
    }

    private void customizeLinux(String type, Jpackage.Linux packager, Path inputsDirectory, Command cmd, Map<String, Object> props) {
        if (StringUtils.isNotBlank((String)packager.getPackageName())) {
            cmd.arg("--linux-package-name").arg(packager.getPackageName());
        }
        if (StringUtils.isNotBlank((String)packager.getMenuGroup())) {
            cmd.arg("--linux-menu-group").arg(packager.getMenuGroup());
        }
        if (StringUtils.isNotBlank((String)packager.getAppRelease())) {
            cmd.arg("--linux-app-release").arg(packager.getAppRelease());
        }
        if (StringUtils.isNotBlank((String)packager.getAppCategory())) {
            cmd.arg("--linux-app-category").arg(packager.getAppCategory());
        }
        if (packager.isShortcut()) {
            cmd.arg("--linux-shortcut");
        }
        if (!packager.getPackageDeps().isEmpty()) {
            cmd.arg("--linux-package-deps").arg(String.join((CharSequence)",", packager.getPackageDeps()));
        }
        if ("deb".equals(type)) {
            if (StringUtils.isNotBlank((String)packager.getMaintainer())) {
                cmd.arg("--linux-deb-maintainer").arg(packager.getMaintainer());
            }
        } else if ("rpm".equals(type) && StringUtils.isNotBlank((String)packager.getLicense())) {
            cmd.arg("--linux-rpm-license-type").arg(packager.getLicense());
        }
        cmd.arg("--icon").arg(inputsDirectory.resolve(((Jpackage)this.assembler).getName() + ".png").toAbsolutePath().toString());
    }

    private void customizeWindows(String type, Jpackage.Windows packager, Path inputsDirectory, Command cmd, Map<String, Object> props) {
        if (packager.isConsole()) {
            cmd.arg("--win-console");
        }
        if (packager.isDirChooser()) {
            cmd.arg("--win-dir-chooser");
        }
        if (packager.isMenu()) {
            cmd.arg("--win-menu");
        }
        if (packager.isPerUserInstall()) {
            cmd.arg("--win-per-user-install");
        }
        if (packager.isShortcut()) {
            cmd.arg("--win-shortcut");
        }
        if (StringUtils.isNotBlank((String)packager.getMenuGroup())) {
            cmd.arg("--win-menu-group").arg(this.maybeQuote(packager.getMenuGroup()));
        }
        if (StringUtils.isNotBlank((String)packager.getUpgradeUuid())) {
            cmd.arg("--win-upgrade-uuid").arg(packager.getUpgradeUuid());
        }
        cmd.arg("--icon").arg(this.maybeQuote(inputsDirectory.resolve(((Jpackage)this.assembler).getName() + ".ico").toAbsolutePath().toString()));
    }

    @Override
    protected void writeFile(Project project, String content, Map<String, Object> props, String fileName) throws AssemblerProcessingException {
        fileName = TemplateUtils.trimTplExtension((String)fileName);
        Path outputDirectory = (Path)props.get("distributionAssembleDirectory");
        Path outputFile = outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }
}

