/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.webhooks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Webhook;
import org.jreleaser.model.announcer.spi.AnnounceException;
import org.jreleaser.model.announcer.spi.Announcer;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;

public class WebhooksAnnouncer
implements Announcer {
    private final JReleaserContext context;

    WebhooksAnnouncer(JReleaserContext context) {
        this.context = context;
    }

    public String getName() {
        return "webhooks";
    }

    public boolean isEnabled() {
        return this.context.getModel().getAnnounce().getConfiguredWebhooks().isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void announce() throws AnnounceException {
        Map webhooks = this.context.getModel().getAnnounce().getWebhooks();
        for (Map.Entry e : webhooks.entrySet()) {
            if (!((Webhook)e.getValue()).isEnabled()) continue;
            this.context.getLogger().setPrefix("webhook." + (String)e.getKey());
            try {
                this.announce((Webhook)e.getValue());
            }
            catch (AnnounceException x) {
                this.context.getLogger().warn(x.getMessage().trim());
            }
            finally {
                this.context.getLogger().restorePrefix();
            }
        }
    }

    public void announce(Webhook webhook) throws AnnounceException {
        String message = "";
        if (StringUtils.isNotBlank((String)webhook.getMessage())) {
            message = webhook.getResolvedMessage(this.context);
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                message = objectMapper.writeValueAsString((Object)CollectionUtils.mapOf((Object[])new Object[]{webhook.getMessageProperty(), message}));
            }
            catch (JsonProcessingException e) {
                throw new AnnounceException(RB.$((String)"ERROR_unexpected_json_format", (Object[])new Object[0]), (Throwable)e);
            }
        } else {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            props.put("changelog", MustacheUtils.passThrough((String)this.context.getChangelog()));
            this.context.getModel().getRelease().getGitService().fillProps(props, this.context.getModel());
            message = webhook.getResolvedMessageTemplate(this.context, props);
        }
        this.context.getLogger().info("message: {}", new Object[]{message});
        if (!this.context.isDryrun()) {
            ClientUtils.webhook((JReleaserLogger)this.context.getLogger(), (String)webhook.getResolvedWebhook(), (int)webhook.getConnectTimeout(), (int)webhook.getReadTimeout(), (String)message);
        }
    }
}

