/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Activatable;
import org.jreleaser.model.Domain;
import org.jreleaser.model.EnabledAware;
import org.jreleaser.model.ExtraProperties;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.TimeoutAware;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public interface Downloader
extends Domain,
Activatable,
TimeoutAware,
ExtraProperties {
    public String getType();

    public String getName();

    public void setName(String var1);

    public List<Asset> getAssets();

    public void setAssets(List<Asset> var1);

    public void addAsset(Asset var1);

    public static class Asset
    extends AbstractModelObject<Asset>
    implements Domain {
        private final Unpack unpack = new Unpack();
        private String input;
        private String output;

        @Override
        public void freeze() {
            super.freeze();
            this.unpack.freeze();
        }

        @Override
        public void merge(Asset asset) {
            this.input = this.merge(this.input, asset.input);
            this.output = this.merge(this.output, asset.output);
            this.setUnpack(asset.unpack);
        }

        public String getResolvedInput(JReleaserContext context, Downloader downloader) {
            Map<String, Object> p = context.getModel().props();
            p.putAll(downloader.getResolvedExtraProperties());
            p.put("downloaderName", downloader.getName());
            return Templates.resolveTemplate((String)this.input, p);
        }

        public String getResolvedOutput(JReleaserContext context, Downloader downloader, String artifactFile) {
            if (StringUtils.isBlank((String)this.output)) {
                return this.output;
            }
            Map<String, Object> p = context.getModel().props();
            p.putAll(downloader.getResolvedExtraProperties());
            p.put("downloaderName", downloader.getName());
            p.put("artifactFile", artifactFile);
            return Templates.resolveTemplate((String)this.output, p);
        }

        public String getInput() {
            return this.input;
        }

        public void setInput(String input) {
            this.input = input;
        }

        public String getOutput() {
            return this.output;
        }

        public void setOutput(String output) {
            this.output = output;
        }

        public Unpack getUnpack() {
            return this.unpack;
        }

        public void setUnpack(Unpack unpack) {
            this.unpack.merge(unpack);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("input", this.input);
            props.put("output", this.output);
            props.put("unpack", this.unpack.asMap(full));
            return props;
        }
    }

    public static class Unpack
    extends AbstractModelObject<Unpack>
    implements Domain,
    EnabledAware {
        private Boolean enabled;
        private Boolean skipRootEntry;

        @Override
        public void merge(Unpack unpack) {
            this.enabled = this.merge(this.enabled, unpack.enabled);
            this.skipRootEntry = this.merge(this.skipRootEntry, unpack.skipRootEntry);
        }

        @Override
        public boolean isEnabled() {
            return this.enabled != null && this.enabled != false;
        }

        @Override
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabledSet() {
            return this.enabled != null;
        }

        public boolean isSkipRootEntry() {
            return this.skipRootEntry != null && this.skipRootEntry != false;
        }

        public void setSkipRootEntry(Boolean skipRootEntry) {
            this.skipRootEntry = skipRootEntry;
        }

        public boolean isSkipRootEntrySet() {
            return this.skipRootEntry != null;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            if (!full && !this.isEnabled()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("enabled", this.isEnabled());
            props.put("skipRootEntry", this.isSkipRootEntry());
            return props;
        }
    }
}

