/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.github.mustachejava.TemplateFunction;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Domain;
import org.jreleaser.model.ExtraProperties;
import org.jreleaser.util.StringUtils;

public class Screenshot
extends AbstractModelObject<Screenshot>
implements Domain,
ExtraProperties {
    protected final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private Type type = Type.SOURCE;
    private Boolean primary;
    private String url;
    private String caption;
    private Integer width;
    private Integer height;

    @Override
    public void merge(Screenshot source) {
        this.freezeCheck();
        this.type = this.merge(this.type, source.type);
        this.primary = this.merge(this.primary, source.primary);
        this.url = this.merge(this.url, source.url);
        this.caption = this.merge(this.caption, source.caption);
        this.width = this.merge(this.width, source.width);
        this.height = this.merge(this.height, source.height);
        this.setExtraProperties(this.merge(this.extraProperties, source.extraProperties));
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.freezeCheck();
        this.type = type;
    }

    public void setType(String str) {
        this.setType(Type.of(str));
    }

    public boolean isPrimary() {
        return this.primary != null && this.primary != false;
    }

    public void setPrimary(Boolean primary) {
        this.freezeCheck();
        this.primary = primary;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.freezeCheck();
        this.url = url;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.freezeCheck();
        this.caption = caption;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.freezeCheck();
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.freezeCheck();
        this.height = height;
    }

    @Override
    public String getPrefix() {
        return "screenshot";
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.freezeWrap(this.extraProperties);
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.freezeCheck();
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.freezeCheck();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("type", (Object)this.type);
        map.put("url", this.url);
        if (this.isPrimary()) {
            map.put("primary", this.isPrimary());
        }
        map.put("caption", this.caption);
        map.put("width", this.width);
        map.put("height", this.height);
        map.put("extraProperties", this.getResolvedExtraProperties());
        return map;
    }

    public ScreenshotTemplate asScreenshotTemplate() {
        return new ScreenshotTemplate(this);
    }

    public static final class ScreenshotTemplate {
        private final String type;
        private final boolean primary;
        private final String url;
        private final String caption;
        private final Integer width;
        private final Integer height;

        public ScreenshotTemplate(Screenshot source) {
            this.type = source.type.toString();
            this.primary = source.isPrimary();
            this.url = source.url;
            this.caption = source.caption;
            this.width = source.width;
            this.height = source.height;
        }

        public String getType() {
            return this.type;
        }

        public TemplateFunction getUrl() {
            return s -> this.url;
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public String getCaption() {
            return this.caption;
        }

        public Integer getWidth() {
            return this.width;
        }

        public Integer getHeight() {
            return this.height;
        }
    }

    public static enum Type {
        SOURCE,
        THUMBNAIL;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public static Type of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return Type.valueOf(str.toUpperCase(Locale.ENGLISH).trim());
        }
    }
}

