/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.releaser.spi;

import java.nio.file.Path;
import java.util.Objects;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;

public class Asset {
    private final Type type;
    private final Artifact artifact;
    private final Distribution distribution;
    private final Path path;
    private final String filename;

    private Asset(Type type, Artifact artifact) {
        this(type, artifact, null);
    }

    private Asset(Type type, Artifact artifact, Distribution distribution) {
        this.type = type;
        this.artifact = artifact;
        this.distribution = distribution;
        this.path = artifact.getEffectivePath();
        this.filename = this.path.getFileName().toString();
    }

    public Type getType() {
        return this.type;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public Path getPath() {
        return this.path;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Asset asset = (Asset)o;
        return this.path.equals(asset.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public static Asset file(Path path) {
        return new Asset(Type.FILE, Artifact.of(path));
    }

    public static Asset checksum(Path path) {
        return new Asset(Type.CHECKSUM, Artifact.of(path));
    }

    public static Asset signature(Path path) {
        return new Asset(Type.SIGNATURE, Artifact.of(path));
    }

    public static Asset file(Artifact artifact) {
        return new Asset(Type.FILE, artifact);
    }

    public static Asset checksum(Artifact artifact) {
        return new Asset(Type.CHECKSUM, artifact);
    }

    public static Asset signature(Artifact artifact) {
        return new Asset(Type.SIGNATURE, artifact);
    }

    public static Asset file(Artifact artifact, Distribution distribution) {
        return new Asset(Type.FILE, artifact, distribution);
    }

    static enum Type {
        CHECKSUM,
        FILE,
        SIGNATURE;

    }
}

