/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Release;
import org.jreleaser.model.validation.CodebergValidator;
import org.jreleaser.model.validation.GenericGitValidator;
import org.jreleaser.model.validation.GiteaValidator;
import org.jreleaser.model.validation.GithubValidator;
import org.jreleaser.model.validation.GitlabValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;

public abstract class ReleaseValidator
extends Validator {
    public static void validateRelease(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("release");
        Release release = context.getModel().getRelease();
        int count = 0;
        if (GithubValidator.validateGithub(context, mode, release.getGithub(), errors)) {
            ++count;
        }
        if (GitlabValidator.validateGitlab(context, mode, release.getGitlab(), errors)) {
            ++count;
        }
        if (GiteaValidator.validateGitea(context, mode, release.getGitea(), errors)) {
            ++count;
        }
        if (CodebergValidator.validateCodeberg(context, mode, release.getCodeberg(), errors)) {
            ++count;
        }
        if (GenericGitValidator.validateGeneric(context, mode, release.getGeneric(), errors)) {
            ++count;
        }
        if (!mode.validateStandalone()) {
            if (0 == count) {
                errors.configuration(RB.$((String)"validation_release_no_providers", (Object[])new Object[0]));
                return;
            }
            if (count > 1) {
                errors.configuration(RB.$((String)"validation_release_requirement", (Object[])new Object[]{"release.[github|gitlab|gitea|codeberg|generic]"}));
            }
        }
    }
}

