/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.commons.feign;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.Util;
import java.nio.charset.Charset;
import java.util.Base64;

public class TokenAuthRequestInterceptor
implements RequestInterceptor {
    public static final String BASIC = "Basic";
    public static final String BEARER = "Bearer";
    private final String headerValue;

    public TokenAuthRequestInterceptor(String password) {
        Util.checkNotNull((Object)password, (String)"password", (Object[])new Object[0]);
        this.headerValue = "Bearer " + password;
    }

    public TokenAuthRequestInterceptor(String username, String password) {
        this(BASIC, username, password, Util.ISO_8859_1);
    }

    public TokenAuthRequestInterceptor(String token, String username, String password) {
        this(token, username, password, Util.ISO_8859_1);
    }

    public TokenAuthRequestInterceptor(String username, String password, Charset charset) {
        this(BASIC, username, password, charset);
    }

    public TokenAuthRequestInterceptor(String token, String username, String password, Charset charset) {
        Util.checkNotNull((Object)token, (String)"token", (Object[])new Object[0]);
        Util.checkNotNull((Object)username, (String)"username", (Object[])new Object[0]);
        Util.checkNotNull((Object)password, (String)"password", (Object[])new Object[0]);
        this.headerValue = token + " " + TokenAuthRequestInterceptor.base64Encode((username + ":" + password).getBytes(charset));
    }

    private static String base64Encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public void apply(RequestTemplate template) {
        template.header("Authorization", new String[]{this.headerValue});
    }
}

