/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.release;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jreleaser.bundle.RB;
import org.jreleaser.extensions.api.workflow.WorkflowListenerException;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.api.hooks.ExecutionEvent;
import org.jreleaser.model.api.release.Releaser;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.release.ReleaseException;
import org.jreleaser.model.spi.release.ReleaserBuilder;
import org.jreleaser.model.spi.release.ReleaserBuilderFactory;

public class Releasers {
    public static void release(JReleaserContext context) throws ReleaseException {
        Releaser releaser = context.getModel().getRelease().releaser();
        boolean failure = false;
        try {
            Releasers.fireAssembleEvent(ExecutionEvent.before((String)JReleaserCommand.RELEASE.toStep()), context, releaser);
            Releasers.releaserFor(context).release();
        }
        catch (RuntimeException e) {
            failure = true;
            Releasers.fireAssembleEvent(ExecutionEvent.failure((String)JReleaserCommand.RELEASE.toStep(), (Throwable)e), context, releaser);
        }
        if (!failure) {
            Releasers.fireAssembleEvent(ExecutionEvent.success((String)JReleaserCommand.RELEASE.toStep()), context, releaser);
        }
    }

    public static org.jreleaser.model.spi.release.Releaser<?> releaserFor(JReleaserContext context) {
        return Releasers.findReleaser(context).configureWith(context).build();
    }

    private static <T extends ReleaserBuilder<?>> T findReleaser(JReleaserContext context) {
        Map<String, ReleaserBuilder> builders = StreamSupport.stream(ServiceLoader.load(ReleaserBuilderFactory.class, Releasers.class.getClassLoader()).spliterator(), false).collect(Collectors.toMap(ReleaserBuilderFactory::getName, ReleaserBuilderFactory::getBuilder));
        if (null != context.getModel().getRelease().getGithub()) {
            return (T)builders.get("github");
        }
        if (null != context.getModel().getRelease().getGitlab()) {
            return (T)builders.get("gitlab");
        }
        if (null != context.getModel().getRelease().getGitea()) {
            return (T)builders.get("gitea");
        }
        if (null != context.getModel().getRelease().getCodeberg()) {
            return (T)builders.get("codeberg");
        }
        if (null != context.getModel().getRelease().getGeneric()) {
            return (T)builders.get("generic");
        }
        throw new JReleaserException(RB.$((String)"ERROR_releaser_no_match", (Object[])new Object[0]));
    }

    private static void fireAssembleEvent(ExecutionEvent event, JReleaserContext context, Releaser releaser) {
        block3: {
            try {
                context.fireReleaseStepEvent(event, releaser);
            }
            catch (WorkflowListenerException e) {
                context.getLogger().error(RB.$((String)"listener.failure", (Object[])new Object[]{e.getListener().getClass().getName()}));
                context.getLogger().trace((Throwable)e);
                if (event.getType() == ExecutionEvent.Type.FAILURE || e.getListener().isContinueOnError()) break block3;
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), e.getCause());
            }
        }
    }
}

