/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.teams;

import java.util.LinkedHashMap;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.sdk.commons.ClientUtils;

public class TeamsAnnouncer
implements Announcer<org.jreleaser.model.api.announce.TeamsAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.TeamsAnnouncer teams;

    public TeamsAnnouncer(JReleaserContext context) {
        this.context = context;
        this.teams = context.getModel().getAnnounce().getTeams();
    }

    public org.jreleaser.model.api.announce.TeamsAnnouncer getAnnouncer() {
        return this.teams.asImmutable();
    }

    public String getName() {
        return "teams";
    }

    public boolean isEnabled() {
        return this.teams.isEnabled();
    }

    public void announce() throws AnnounceException {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("changelog", MustacheUtils.passThrough((String)TeamsAnnouncer.convertLineEndings(this.context.getChangelog())));
        this.context.getModel().getRelease().getReleaser().fillProps(props, this.context.getModel());
        String message = this.teams.getResolvedMessageTemplate(this.context, props);
        this.context.getLogger().info(RB.$((String)"webhook.message.send", (Object[])new Object[0]));
        if (!this.context.isDryrun()) {
            ClientUtils.webhook((JReleaserLogger)this.context.getLogger(), (String)this.teams.getResolvedWebhook(), (int)this.teams.getConnectTimeout(), (int)this.teams.getReadTimeout(), (String)message);
        }
    }

    public static String convertLineEndings(String str) {
        return str.replaceAll("\\n", "\\\\n\\\\n");
    }
}

