/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitlab;

import feign.form.FormData;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.upload.GitlabUploader;
import org.jreleaser.model.spi.upload.UploadException;
import org.jreleaser.sdk.commons.AbstractArtifactUploader;
import org.jreleaser.sdk.commons.ClientUtils;

public class GitlabArtifactUploader
extends AbstractArtifactUploader<org.jreleaser.model.api.upload.GitlabUploader, GitlabUploader> {
    private GitlabUploader uploader;

    public GitlabArtifactUploader(JReleaserContext context) {
        super(context);
    }

    public GitlabUploader getUploader() {
        return this.uploader;
    }

    public void setUploader(GitlabUploader uploader) {
        this.uploader = uploader;
    }

    public String getType() {
        return "gitlab";
    }

    public void upload(String name) throws UploadException {
        List artifacts = this.collectArtifacts();
        if (artifacts.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"artifacts.no.match", (Object[])new Object[0]));
        }
        String token = this.uploader.getResolvedToken();
        for (Artifact artifact : artifacts) {
            Path path = artifact.getEffectivePath(this.context);
            this.context.getLogger().info(" - {}", new Object[]{path.getFileName()});
            if (this.context.isDryrun()) continue;
            try {
                LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
                headers.put("Authorization", "Bearer " + token);
                FormData data = ClientUtils.toFormData((Path)path);
                ClientUtils.putFile((JReleaserLogger)this.context.getLogger(), (String)this.uploader.getResolvedUploadUrl(this.context, artifact), (int)this.uploader.getConnectTimeout(), (int)this.uploader.getReadTimeout(), (FormData)data, headers);
            }
            catch (IOException e) {
                this.context.getLogger().trace((Throwable)e);
                throw new UploadException(RB.$((String)"ERROR_unexpected_upload", (Object[])new Object[]{this.context.getBasedir().relativize(path)}), (Throwable)e);
            }
            catch (UploadException e) {
                throw new UploadException(RB.$((String)"ERROR_unexpected_upload", (Object[])new Object[]{this.context.getBasedir().relativize(path)}), e.getCause());
            }
        }
    }
}

