/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.model.internal.util.Artifacts;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class Glob
extends AbstractModelObject<Glob>
implements Domain,
ExtraProperties {
    private static final String GLOB_PREFIX = "glob:";
    private static final String REGEX_PREFIX = "regex:";
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private String pattern;
    private String platform;
    @JsonIgnore
    private Set<Artifact> artifacts;
    private String directory;
    private final org.jreleaser.model.api.common.Glob immutable = new org.jreleaser.model.api.common.Glob(){

        public String getPattern() {
            return Glob.this.pattern;
        }

        public String getPlatform() {
            return Glob.this.platform;
        }

        public String getDirectory() {
            return Glob.this.directory;
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Glob.this.asMap(full));
        }

        public String getPrefix() {
            return Glob.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(Glob.this.extraProperties);
        }
    };

    public org.jreleaser.model.api.common.Glob asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Glob source) {
        this.pattern = this.merge(this.pattern, source.pattern);
        this.platform = this.merge(this.platform, source.platform);
        this.setExtraProperties(this.merge(this.extraProperties, source.extraProperties));
    }

    @Override
    public String getPrefix() {
        return "artifact";
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        if (StringUtils.isBlank((String)pattern)) {
            return;
        }
        this.pattern = pattern.trim();
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("pattern", this.pattern);
        props.put("platform", this.platform);
        props.put("extraProperties", this.getResolvedExtraProperties());
        props.put("directory", this.directory);
        return props;
    }

    public Set<Artifact> getResolvedArtifacts(JReleaserContext context) {
        return this.getResolvedArtifactsPattern(context);
    }

    public Set<Artifact> getResolvedArtifactsPattern(JReleaserContext context) {
        if (null == this.artifacts) {
            this.setPattern(Artifacts.resolveForGlob(this.getPattern(), context, this));
            this.normalizePattern(this.resolveDirectory(context));
            this.artifacts = Artifacts.resolveFiles(context, this.resolveDirectory(context), Collections.singletonList(this.pattern));
            this.artifacts.forEach(artifact -> {
                artifact.setPlatform(this.platform);
                if (context.isPlatformSelected((Artifact)artifact)) {
                    artifact.activate();
                }
                artifact.setExtraProperties(this.getExtraProperties());
            });
        }
        return this.artifacts;
    }

    private Path resolveDirectory(JReleaserContext context) {
        Path path = context.getBasedir();
        if (StringUtils.isNotBlank((String)this.directory)) {
            this.directory = Artifacts.resolveForGlob(this.directory, context, this);
            path = context.getBasedir().resolve(Paths.get(this.directory, new String[0])).normalize();
            if (context.getMode().validatePaths() && !Files.exists(path, new LinkOption[0])) {
                throw new JReleaserException(RB.$((String)"ERROR_path_does_not_exist", (Object[])new Object[]{context.relativizeToBasedir(path)}));
            }
        }
        return path;
    }

    private void normalizePattern(Path basedir) {
        if (!this.pattern.startsWith(GLOB_PREFIX) && !this.pattern.startsWith(REGEX_PREFIX)) {
            this.pattern = GLOB_PREFIX + this.pattern;
        }
        if (this.pattern.startsWith(GLOB_PREFIX)) {
            String path;
            String test = path = this.pattern.substring(GLOB_PREFIX.length());
            if (PlatformUtils.isWindows()) {
                test = test.replace("*", "x");
            }
            this.pattern = !Paths.get(test, new String[0]).isAbsolute() ? "glob:**" + File.separator + path : "glob:**" + this.relativize(basedir, Paths.get(path, new String[0]));
        } else {
            String path;
            String test = path = this.pattern.substring(REGEX_PREFIX.length());
            if (PlatformUtils.isWindows()) {
                test = test.replace("*", "x");
            }
            this.pattern = !Paths.get(test, new String[0]).isAbsolute() ? "regex:.*" + File.separator + path : "regex:.*" + this.relativize(basedir, Paths.get(path, new String[0]));
        }
        if (PlatformUtils.isWindows()) {
            this.pattern = this.pattern.replace("/", "\\\\");
        }
    }

    private Path relativize(Path base, Path other) {
        Path p1 = base.toAbsolutePath();
        Path p2 = other.toAbsolutePath();
        return p1.relativize(p2).normalize();
    }
}

