/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.deploy;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.deploy.maven.Maven;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.util.Env;

public final class Deploy
extends AbstractModelObject<Deploy>
implements Domain,
Activatable {
    private final Maven maven = new Maven();
    private Active active;
    @JsonIgnore
    private boolean enabled = true;
    private final org.jreleaser.model.api.deploy.Deploy immutable = new org.jreleaser.model.api.deploy.Deploy(){

        public org.jreleaser.model.api.deploy.maven.Maven getMaven() {
            return Deploy.this.maven.asImmutable();
        }

        public Active getActive() {
            return Deploy.this.active;
        }

        public boolean isEnabled() {
            return Deploy.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Deploy.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.deploy.Deploy asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Deploy source) {
        this.active = this.merge(this.active, source.active);
        this.enabled = this.merge(this.enabled, source.enabled);
        this.setMaven(source.maven);
    }

    public boolean isSet() {
        return this.maven.isSet();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.setActive(Env.resolveOrDefault((String)"deploy.active", (String)"", (String)"ALWAYS"));
        }
        this.enabled = this.active.check((Active.Releaseable)project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of((String)str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    public Maven getMaven() {
        return this.maven;
    }

    public void setMaven(Maven maven) {
        this.maven.merge(maven);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.active);
        map.put("maven", this.maven.asMap(full));
        return map;
    }
}

