/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.download;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.api.download.Downloader;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.EnabledAware;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.model.internal.common.TimeoutAware;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.StringUtils;

public interface Downloader<A extends org.jreleaser.model.api.download.Downloader>
extends Domain,
Activatable,
TimeoutAware,
ExtraProperties {
    public String getType();

    public String getName();

    public void setName(String var1);

    public List<Asset> getAssets();

    public void setAssets(List<Asset> var1);

    public void addAsset(Asset var1);

    public A asImmutable();

    public static class Asset
    extends AbstractModelObject<Asset>
    implements Domain {
        private final Unpack unpack = new Unpack();
        private String input;
        private String output;
        private final Downloader.Asset immutable = new Downloader.Asset(){

            public String getInput() {
                return input;
            }

            public String getOutput() {
                return output;
            }

            public Downloader.Unpack getUnpack() {
                return unpack.asImmutable();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Downloader.Asset asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Asset source) {
            this.input = this.merge(this.input, source.input);
            this.output = this.merge(this.output, source.output);
            this.setUnpack(source.unpack);
        }

        public String getResolvedInput(JReleaserContext context, Downloader downloader) {
            Map<String, Object> p = context.getModel().props();
            p.putAll(downloader.getResolvedExtraProperties());
            p.put("downloaderName", downloader.getName());
            return Templates.resolveTemplate((String)this.input, p);
        }

        public String getResolvedOutput(JReleaserContext context, Downloader downloader, String artifactFile) {
            if (StringUtils.isBlank((String)this.output)) {
                return this.output;
            }
            Map<String, Object> p = context.getModel().props();
            p.putAll(downloader.getResolvedExtraProperties());
            p.put("downloaderName", downloader.getName());
            p.put("artifactFile", artifactFile);
            return Templates.resolveTemplate((String)this.output, p);
        }

        public String getInput() {
            return this.input;
        }

        public void setInput(String input) {
            this.input = input;
        }

        public String getOutput() {
            return this.output;
        }

        public void setOutput(String output) {
            this.output = output;
        }

        public Unpack getUnpack() {
            return this.unpack;
        }

        public void setUnpack(Unpack unpack) {
            this.unpack.merge(unpack);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("input", this.input);
            props.put("output", this.output);
            props.put("unpack", this.unpack.asMap(full));
            return props;
        }
    }

    public static class Unpack
    extends AbstractModelObject<Unpack>
    implements Domain,
    EnabledAware {
        private Boolean enabled;
        private Boolean skipRootEntry;
        public final Downloader.Unpack immutable = new Downloader.Unpack(){

            public boolean isSkipRootEntry() {
                return this.isSkipRootEntry();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }
        };

        public Downloader.Unpack asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Unpack source) {
            this.enabled = this.merge(this.enabled, source.enabled);
            this.skipRootEntry = this.merge(this.skipRootEntry, source.skipRootEntry);
        }

        @Override
        public boolean isEnabled() {
            return this.enabled != null && this.enabled != false;
        }

        @Override
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabledSet() {
            return this.enabled != null;
        }

        public boolean isSkipRootEntry() {
            return this.skipRootEntry != null && this.skipRootEntry != false;
        }

        public void setSkipRootEntry(Boolean skipRootEntry) {
            this.skipRootEntry = skipRootEntry;
        }

        public boolean isSkipRootEntrySet() {
            return this.skipRootEntry != null;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            if (!full && !this.isEnabled()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("enabled", this.isEnabled());
            props.put("skipRootEntry", this.isSkipRootEntry());
            return props;
        }
    }
}

