/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.upload;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.upload.AbstractUploader;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public final class GitlabUploader
extends AbstractUploader<org.jreleaser.model.api.upload.GitlabUploader, GitlabUploader> {
    private static final String DOWNLOAD_URL = "https://{{host}}/api/v4/projects/{{projectIdentifier}}/packages/generic/{{packageName}}/{{packageVersion}}/{{artifactFile}}";
    private String host;
    private String token;
    private String packageName;
    private String packageVersion;
    private String projectIdentifier;
    private final org.jreleaser.model.api.upload.GitlabUploader immutable = new org.jreleaser.model.api.upload.GitlabUploader(){

        public String getHost() {
            return GitlabUploader.this.host;
        }

        public String getToken() {
            return GitlabUploader.this.token;
        }

        public String getPackageName() {
            return GitlabUploader.this.packageName;
        }

        public String getPackageVersion() {
            return GitlabUploader.this.packageVersion;
        }

        public String getProjectIdentifier() {
            return GitlabUploader.this.projectIdentifier;
        }

        public String getType() {
            return GitlabUploader.this.type;
        }

        public String getName() {
            return GitlabUploader.this.name;
        }

        public boolean isSnapshotSupported() {
            return GitlabUploader.this.isSnapshotSupported();
        }

        public boolean isArtifacts() {
            return GitlabUploader.this.isArtifacts();
        }

        public boolean isFiles() {
            return GitlabUploader.this.isFiles();
        }

        public boolean isSignatures() {
            return GitlabUploader.this.isSignatures();
        }

        public boolean isChecksums() {
            return GitlabUploader.this.isChecksums();
        }

        public Active getActive() {
            return GitlabUploader.this.active;
        }

        public boolean isEnabled() {
            return GitlabUploader.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(GitlabUploader.this.asMap(full));
        }

        public String getPrefix() {
            return GitlabUploader.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(GitlabUploader.this.extraProperties);
        }

        public Integer getConnectTimeout() {
            return GitlabUploader.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return GitlabUploader.this.readTimeout;
        }
    };

    public GitlabUploader() {
        super("gitlab");
        this.setHost("gitlab.com");
    }

    @Override
    public org.jreleaser.model.api.upload.GitlabUploader asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(GitlabUploader source) {
        super.merge(source);
        this.host = this.merge(this.host, source.host);
        this.token = this.merge(this.token, source.token);
        this.packageName = this.merge(this.packageName, source.packageName);
        this.packageVersion = this.merge(this.packageVersion, source.packageVersion);
        this.projectIdentifier = this.merge(this.projectIdentifier, source.projectIdentifier);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public String getProjectIdentifier() {
        return this.projectIdentifier;
    }

    public void setProjectIdentifier(String projectIdentifier) {
        this.projectIdentifier = projectIdentifier;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("host", this.host);
        props.put("token", StringUtils.isNotBlank((String)this.getResolvedToken()) ? "************" : "**unset**");
        props.put("packageName", this.packageName);
        props.put("packageVersion", this.packageVersion);
        props.put("projectIdentifier", this.projectIdentifier);
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, Artifact artifact) {
        return this.getResolvedDownloadUrl(context.fullProps(), artifact);
    }

    @Override
    public String getResolvedDownloadUrl(Map<String, Object> props, Artifact artifact) {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>(this.artifactProps(props, artifact));
        p.putAll(this.getResolvedExtraProperties());
        p.put("host", this.host);
        p.put("packageName", this.packageName);
        p.put("packageVersion", this.packageVersion);
        p.put("projectIdentifier", this.projectIdentifier);
        return Templates.resolveTemplate((String)DOWNLOAD_URL, p);
    }

    public String getResolvedToken() {
        return Env.env((Collection)CollectionUtils.listOf((Object[])new String[]{"GITLAB_" + Env.toVar((String)this.name) + "_TOKEN", "GITLAB_TOKEN"}), (String)this.token);
    }

    public String getResolvedUploadUrl(JReleaserContext context, Artifact artifact) {
        return this.getResolvedDownloadUrl(context, artifact);
    }
}

