/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.DiscourseAnnouncer;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class DiscourseAnnouncerValidator
extends Validator {
    private static final String DEFAULT_DISCOURSE_TPL = "src/jreleaser/templates/discourse.tpl";

    public static void validateDiscourse(JReleaserContext context, DiscourseAnnouncer discourse, Errors errors) {
        context.getLogger().debug("announce.discourse");
        if (!discourse.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((String)discourse.getHost())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"discourse.host"}));
        }
        discourse.setUsername(DiscourseAnnouncerValidator.checkProperty(context, "DISCOURSE_USERNAME", "discourse.username", discourse.getUsername(), errors, context.isDryrun()));
        discourse.setApiKey(DiscourseAnnouncerValidator.checkProperty(context, "DISCOURSE_API_KEY", "discourse.apiKey", discourse.getApiKey(), errors, context.isDryrun()));
        discourse.setCategoryName(DiscourseAnnouncerValidator.checkProperty(context, "DISCOURSE_CATEGORY_NAME", "discourse.category", discourse.getCategoryName(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)discourse.getTitle())) {
            discourse.setTitle(RB.$((String)"default.discussion.title", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((String)discourse.getMessage()) && StringUtils.isBlank((String)discourse.getMessageTemplate())) {
            discourse.setMessageTemplate(DEFAULT_DISCOURSE_TPL);
        }
        if (StringUtils.isBlank((String)discourse.getMessage()) && StringUtils.isBlank((String)discourse.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_DISCOURSE_TPL), new LinkOption[0])) {
                discourse.setMessageTemplate(DEFAULT_DISCOURSE_TPL);
            } else {
                discourse.setMessage(RB.$((String)"default.release.message", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)discourse.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(discourse.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"discourse.messageTemplate", discourse.getMessageTemplate()}));
        }
        DiscourseAnnouncerValidator.validateTimeout(discourse);
    }
}

