/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.extensions;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.extensions.Extension;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class ExtensionsValidator
extends Validator {
    public static void validateExtensions(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, Extension> extensions = context.getModel().getExtensions();
        if (!extensions.isEmpty()) {
            context.getLogger().debug("extensions");
        }
        for (Map.Entry<String, Extension> e : extensions.entrySet()) {
            Extension extension = e.getValue();
            if (StringUtils.isBlank((String)extension.getName())) {
                extension.setName(e.getKey());
            }
            ExtensionsValidator.validateExtension(context, mode, extension, errors);
        }
    }

    private static void validateExtension(JReleaserContext context, JReleaserContext.Mode mode, Extension extension, Errors errors) {
        context.getLogger().debug("extension.{}", new Object[]{extension.getName()});
        if (!extension.isEnabledSet()) {
            extension.setEnabled(true);
        }
        if (!extension.isEnabled()) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isNotBlank((String)extension.getDirectory()) && !Files.exists(context.getBasedir().resolve(extension.getDirectory().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"extension." + extension.getName() + ".directory", extension.getDirectory()}));
        }
        if (StringUtils.isNotBlank((String)extension.getGav()) && StringUtils.isNotBlank((String)extension.getDirectory())) {
            errors.configuration(RB.$((String)"validation_extension_gav_directory", (Object[])new Object[]{"extension." + extension.getName()}));
        }
        for (int i = 0; i < extension.getProviders().size(); ++i) {
            ExtensionsValidator.validateExtensionProvider(context, mode, extension, extension.getProviders().get(i), i, errors);
        }
    }

    private static void validateExtensionProvider(JReleaserContext context, JReleaserContext.Mode mode, Extension extension, Extension.Provider provider, int index, Errors errors) {
        if (StringUtils.isBlank((String)provider.getType())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"extensions.{}.providers[{}]", extension.getName(), index}));
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            extension.setEnabled(false);
        }
    }
}

