/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.upload;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.upload.S3Uploader;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class S3UploaderValidator
extends Validator {
    public static void validateS3(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, S3Uploader> s3 = context.getModel().getUpload().getS3();
        if (!s3.isEmpty()) {
            context.getLogger().debug("upload.s3");
        }
        for (Map.Entry<String, S3Uploader> e : s3.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) continue;
            S3UploaderValidator.validateS3(context, mode, e.getValue(), errors);
        }
    }

    private static void validateS3(JReleaserContext context, JReleaserContext.Mode mode, S3Uploader s3, Errors errors) {
        context.getLogger().debug("upload.s3.{}", new Object[]{s3.getName()});
        if (!s3.isActiveSet()) {
            s3.setActive(Active.NEVER);
        }
        if (!s3.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!(s3.isArtifacts() || s3.isFiles() || s3.isSignatures())) {
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            s3.disable();
            return;
        }
        s3.setRegion(S3UploaderValidator.checkProperty(context, Env.toVar((String)("S3_" + s3.getName())) + "_REGION", "s3." + s3.getName() + ".region", s3.getRegion(), errors));
        s3.setBucket(S3UploaderValidator.checkProperty(context, Env.toVar((String)("S3_" + s3.getName())) + "_BUCKET", "s3." + s3.getName() + ".bucket", s3.getBucket(), errors));
        s3.setAccessKeyId(S3UploaderValidator.checkProperty(context, Env.toVar((String)("S3_" + s3.getName())) + "_ACCESS_KEY_ID", "s3." + s3.getName() + ".accessKeyId", s3.getAccessKeyId(), s3.getResolvedAccessKeyId()));
        s3.setSecretKey(S3UploaderValidator.checkProperty(context, Env.toVar((String)("S3_" + s3.getName())) + "_SECRET_KEY", "s3." + s3.getName() + ".secretKey", s3.getSecretKey(), s3.getResolvedSecretKey()));
        s3.setSessionToken(S3UploaderValidator.checkProperty(context, Env.toVar((String)("S3_" + s3.getName())) + "_SESSION_TOKEN", "s3." + s3.getName() + ".sessionToken", s3.getSessionToken(), s3.getResolvedSessionToken()));
        s3.setPath(S3UploaderValidator.checkProperty(context, Env.toVar((String)("S3_" + s3.getName())) + "_PATH", "s3." + s3.getName() + ".path", s3.getPath(), "{{projectName}}/{{tagName}}/{{artifactFile}}"));
        s3.setDownloadUrl(S3UploaderValidator.checkProperty(context, Env.toVar((String)("S3_" + s3.getName())) + "_DOWNLOAD_URL", "s3." + s3.getName() + ".downloadUrl", s3.getDownloadUrl(), s3.getResolvedDownloadUrl()));
        s3.setEndpoint(S3UploaderValidator.checkProperty(context, Env.toVar((String)("S3_" + s3.getName())) + "_ENDPOINT", "s3." + s3.getName() + ".endpoint", s3.getEndpoint(), ""));
        if (StringUtils.isNotBlank((String)s3.getResolvedEndpoint()) && StringUtils.isBlank((String)s3.getResolvedDownloadUrl())) {
            errors.configuration(RB.$((String)"validation_s3_missing_download_url", (Object[])new Object[]{"s3." + s3.getName()}));
        }
        S3UploaderValidator.validateTimeout(s3);
    }
}

