/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.download;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.download.Downloader;
import org.jreleaser.model.internal.common.Ftp;
import org.jreleaser.model.internal.download.AbstractDownloader;
import org.jreleaser.model.internal.download.Downloader;
import org.jreleaser.util.StringUtils;

public final class FtpDownloader
extends AbstractDownloader<org.jreleaser.model.api.download.FtpDownloader, FtpDownloader>
implements Ftp {
    private String username;
    private String password;
    private String host;
    private Integer port;
    private final org.jreleaser.model.api.download.FtpDownloader immutable = new org.jreleaser.model.api.download.FtpDownloader(){
        private List<? extends Downloader.Asset> assets;

        public String getType() {
            return FtpDownloader.this.type;
        }

        public String getName() {
            return FtpDownloader.this.name;
        }

        public List<? extends Downloader.Asset> getAssets() {
            if (null == this.assets) {
                this.assets = FtpDownloader.this.assets.stream().map(Downloader.Asset::asImmutable).collect(Collectors.toList());
            }
            return this.assets;
        }

        public Active getActive() {
            return FtpDownloader.this.active;
        }

        public boolean isEnabled() {
            return FtpDownloader.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(FtpDownloader.this.asMap(full));
        }

        public String getPrefix() {
            return FtpDownloader.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(FtpDownloader.this.extraProperties);
        }

        public String getUsername() {
            return FtpDownloader.this.username;
        }

        public String getPassword() {
            return FtpDownloader.this.password;
        }

        public String getHost() {
            return FtpDownloader.this.host;
        }

        public Integer getPort() {
            return FtpDownloader.this.port;
        }

        public Integer getConnectTimeout() {
            return FtpDownloader.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return FtpDownloader.this.readTimeout;
        }
    };

    public FtpDownloader() {
        super("ftp");
    }

    @Override
    public org.jreleaser.model.api.download.FtpDownloader asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(FtpDownloader source) {
        super.merge(source);
        this.username = this.merge(this.username, source.username);
        this.password = this.merge(this.password, source.password);
        this.host = this.merge(this.host, source.host);
        this.port = this.merge(this.port, source.port);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public Integer getPort() {
        return null != this.port ? this.port : 21;
    }

    @Override
    public void setPort(Integer port) {
        this.port = port;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("host", this.host);
        props.put("port", this.getPort());
        props.put("username", StringUtils.isNotBlank((String)this.username) ? "************" : "**unset**");
        props.put("password", StringUtils.isNotBlank((String)this.password) ? "************" : "**unset**");
    }
}

