/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.Packager;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.util.FileType;

public abstract class AbstractPackager<A extends org.jreleaser.model.api.packagers.Packager, S extends AbstractPackager<A, S>>
extends AbstractModelObject<S>
implements Packager<A> {
    @JsonIgnore
    protected final String type;
    protected final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    @JsonIgnore
    protected boolean enabled;
    protected Active active;
    protected Boolean continueOnError;
    protected String downloadUrl;
    @JsonIgnore
    protected boolean failed;

    protected AbstractPackager(String type) {
        this.type = type;
    }

    @Override
    public void merge(S source) {
        this.active = this.merge(this.active, ((AbstractPackager)source).active);
        this.enabled = this.merge(this.enabled, ((AbstractPackager)source).enabled);
        this.continueOnError = this.merge(this.continueOnError, ((AbstractPackager)source).continueOnError);
        this.downloadUrl = this.merge(this.downloadUrl, ((AbstractPackager)source).downloadUrl);
        this.failed = ((AbstractPackager)source).failed;
        this.setExtraProperties(this.merge(this.extraProperties, ((AbstractPackager)source).extraProperties));
    }

    @Override
    public Set<Stereotype> getSupportedStereotypes() {
        return EnumSet.allOf(Stereotype.class);
    }

    @Override
    public void fail() {
        this.failed = true;
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    @Override
    public List<Artifact> resolveCandidateArtifacts(JReleaserContext context, Distribution distribution) {
        if (distribution.getType() == Distribution.DistributionType.FLAT_BINARY && this.supportsDistribution(distribution.getType())) {
            return distribution.getArtifacts().stream().filter(Artifact::isActive).filter(artifact -> this.supportsPlatform(artifact.getPlatform())).filter(this::isNotSkipped).sorted(Artifact.comparatorByPlatform()).collect(Collectors.toList());
        }
        ArrayList<String> fileExtensions = new ArrayList<String>(this.getSupportedFileExtensions(distribution.getType()));
        fileExtensions.sort(Comparator.naturalOrder());
        return distribution.getArtifacts().stream().filter(Artifact::isActive).filter(artifact -> fileExtensions.stream().anyMatch(ext -> artifact.getResolvedPath(context, distribution).toString().endsWith((String)ext))).filter(artifact -> this.supportsPlatform(artifact.getPlatform())).filter(this::isNotSkipped).sorted(Artifact.comparatorByPlatform().thenComparingInt(artifact -> {
            String ext = FileType.getExtension((Path)artifact.getResolvedPath(context, distribution));
            return fileExtensions.indexOf(ext);
        })).collect(Collectors.toList());
    }

    protected abstract boolean isNotSkipped(Artifact var1);

    @Override
    public boolean isSnapshotSupported() {
        return false;
    }

    @Override
    public String getPrefix() {
        return this.getType();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    @Override
    public boolean isContinueOnError() {
        return this.continueOnError != null && this.continueOnError != false;
    }

    @Override
    public void setContinueOnError(Boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    @Override
    public boolean isContinueOnErrorSet() {
        return this.continueOnError != null;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.active = Active.NEVER;
        }
        this.enabled = this.active.check((Active.Releaseable)project);
        return this.enabled;
    }

    public boolean resolveEnabled(Project project, Distribution distribution) {
        if (null == this.active) {
            this.active = Active.NEVER;
        }
        this.enabled = this.active.check((Active.Releaseable)project);
        if (!this.supportsDistribution(distribution.getType())) {
            this.enabled = false;
        }
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of((String)str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    @Override
    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", this.active);
        props.put("continueOnError", this.isContinueOnError());
        props.put("downloadUrl", this.downloadUrl);
        this.asMap(full, props);
        props.put("extraProperties", this.getResolvedExtraProperties());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.getType(), props);
        return map;
    }

    protected abstract void asMap(boolean var1, Map<String, Object> var2);
}

