/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.release;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Active;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.model.api.common.Apply;
import org.jreleaser.model.api.release.Releaser;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.CommitAuthor;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.EnabledAware;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.Changelog;
import org.jreleaser.model.internal.release.Releaser;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.Env;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.SemanticVersion;

public abstract class BaseReleaser<A extends org.jreleaser.model.api.release.Releaser, S extends BaseReleaser<A, S>>
extends AbstractModelObject<S>
implements Releaser<A> {
    @JsonIgnore
    protected final String serviceName;
    protected final Changelog changelog = new Changelog();
    protected final Milestone milestone = new Milestone();
    protected final Issues issues = new Issues();
    protected final CommitAuthor commitAuthor = new CommitAuthor();
    protected final Update update = new Update();
    protected final Prerelease prerelease = new Prerelease();
    @JsonIgnore
    protected final boolean releaseSupported;
    @JsonIgnore
    protected boolean match = true;
    protected Boolean enabled;
    protected String host;
    protected String owner;
    protected String name;
    protected String repoUrl;
    protected String repoCloneUrl;
    protected String commitUrl;
    protected String srcUrl;
    protected String downloadUrl;
    protected String releaseNotesUrl;
    protected String latestReleaseUrl;
    protected String issueTrackerUrl;
    protected String username;
    protected String token;
    protected String tagName;
    protected String previousTagName;
    protected String releaseName;
    protected String branch;
    protected Boolean sign;
    protected Boolean skipTag;
    protected Boolean skipRelease;
    protected Boolean overwrite;
    protected String apiEndpoint;
    protected int connectTimeout;
    protected int readTimeout;
    protected Boolean artifacts;
    protected Boolean files;
    protected Boolean checksums;
    protected Boolean signatures;
    protected Active uploadAssets;
    protected Boolean uploadAssetsEnabled;
    @JsonIgnore
    protected String cachedTagName;
    @JsonIgnore
    protected String cachedReleaseName;

    protected BaseReleaser(String serviceName, boolean releaseSupported) {
        this.serviceName = serviceName;
        this.releaseSupported = releaseSupported;
    }

    @Override
    public boolean isReleaseSupported() {
        return this.releaseSupported;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public void merge(S source) {
        this.match = ((BaseReleaser)source).match;
        this.enabled = this.merge(this.enabled, ((BaseReleaser)source).enabled);
        this.host = this.merge(this.host, ((BaseReleaser)source).host);
        this.owner = this.merge(this.owner, ((BaseReleaser)source).owner);
        this.name = this.merge(this.name, ((BaseReleaser)source).name);
        this.repoUrl = this.merge(this.repoUrl, ((BaseReleaser)source).repoUrl);
        this.repoCloneUrl = this.merge(this.repoCloneUrl, ((BaseReleaser)source).repoCloneUrl);
        this.commitUrl = this.merge(this.commitUrl, ((BaseReleaser)source).commitUrl);
        this.srcUrl = this.merge(this.srcUrl, ((BaseReleaser)source).srcUrl);
        this.downloadUrl = this.merge(this.downloadUrl, ((BaseReleaser)source).downloadUrl);
        this.releaseNotesUrl = this.merge(this.releaseNotesUrl, ((BaseReleaser)source).releaseNotesUrl);
        this.latestReleaseUrl = this.merge(this.latestReleaseUrl, ((BaseReleaser)source).latestReleaseUrl);
        this.issueTrackerUrl = this.merge(this.issueTrackerUrl, ((BaseReleaser)source).issueTrackerUrl);
        this.username = this.merge(this.username, ((BaseReleaser)source).username);
        this.token = this.merge(this.token, ((BaseReleaser)source).token);
        this.tagName = this.merge(this.tagName, ((BaseReleaser)source).tagName);
        this.previousTagName = this.merge(this.previousTagName, ((BaseReleaser)source).previousTagName);
        this.releaseName = this.merge(this.releaseName, ((BaseReleaser)source).releaseName);
        this.branch = this.merge(this.branch, ((BaseReleaser)source).branch);
        this.sign = this.merge(this.sign, ((BaseReleaser)source).sign);
        this.skipTag = this.merge(this.skipTag, ((BaseReleaser)source).skipTag);
        this.skipRelease = this.merge(this.skipRelease, ((BaseReleaser)source).skipRelease);
        this.overwrite = this.merge(this.overwrite, ((BaseReleaser)source).overwrite);
        this.apiEndpoint = this.merge(this.apiEndpoint, ((BaseReleaser)source).apiEndpoint);
        this.connectTimeout = this.merge(this.connectTimeout, ((BaseReleaser)source).connectTimeout);
        this.readTimeout = this.merge(this.readTimeout, ((BaseReleaser)source).readTimeout);
        this.artifacts = this.merge(this.artifacts, ((BaseReleaser)source).artifacts);
        this.files = this.merge(this.files, ((BaseReleaser)source).files);
        this.checksums = this.merge(this.checksums, ((BaseReleaser)source).checksums);
        this.signatures = this.merge(this.signatures, ((BaseReleaser)source).signatures);
        this.uploadAssets = this.merge(this.uploadAssets, ((BaseReleaser)source).uploadAssets);
        this.uploadAssetsEnabled = this.merge(this.uploadAssetsEnabled, ((BaseReleaser)source).uploadAssetsEnabled);
        this.setCommitAuthor(((BaseReleaser)source).commitAuthor);
        this.setUpdate(((BaseReleaser)source).update);
        this.setPrerelease(((BaseReleaser)source).prerelease);
        this.setChangelog(((BaseReleaser)source).changelog);
        this.setMilestone(((BaseReleaser)source).milestone);
        this.setIssues(((BaseReleaser)source).issues);
    }

    public abstract String getReverseRepoHost();

    public boolean isPrerelease() {
        return this.getPrerelease().isEnabled();
    }

    public String getCanonicalRepoName() {
        if (StringUtils.isNotBlank((String)this.owner)) {
            return this.owner + "/" + this.name;
        }
        return this.name;
    }

    public String getConfiguredTagName() {
        return Env.env((String)"TAG_NAME", (String)this.tagName);
    }

    public String getConfiguredPreviousTagName() {
        return Env.env((String)"PREVIOUS_TAG_NAME", (String)this.previousTagName);
    }

    public String getResolvedTagName(JReleaserModel model) {
        if (StringUtils.isBlank((String)this.cachedTagName)) {
            this.cachedTagName = this.getConfiguredTagName();
        }
        if (StringUtils.isBlank((String)this.cachedTagName)) {
            this.cachedTagName = Templates.resolveTemplate((String)this.tagName, this.props(model));
        } else if (this.cachedTagName.contains("{{")) {
            this.cachedTagName = Templates.resolveTemplate((String)this.cachedTagName, this.props(model));
        }
        return this.cachedTagName;
    }

    public String getEffectiveTagName(JReleaserModel model) {
        if (model.getProject().isSnapshot()) {
            return model.getProject().getSnapshot().getResolvedLabel(model);
        }
        return this.cachedTagName;
    }

    public String getConfiguredReleaseName() {
        return Env.env((String)"RELEASE_NAME", (String)this.cachedReleaseName);
    }

    public String getResolvedReleaseName(JReleaserModel model) {
        if (StringUtils.isBlank((String)this.cachedReleaseName)) {
            this.cachedReleaseName = this.getConfiguredReleaseName();
        }
        if (StringUtils.isBlank((String)this.cachedReleaseName)) {
            this.cachedReleaseName = Templates.resolveTemplate((String)this.releaseName, this.props(model));
        } else if (this.cachedReleaseName.contains("{{")) {
            this.cachedReleaseName = Templates.resolveTemplate((String)this.cachedReleaseName, this.props(model));
        }
        return this.cachedReleaseName;
    }

    public String getEffectiveReleaseName() {
        return this.cachedReleaseName;
    }

    public String getResolvedRepoUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.repoUrl, this.props(model));
    }

    public String getResolvedRepoCloneUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.repoCloneUrl, this.props(model));
    }

    public String getResolvedRepoUrl(JReleaserModel model, String repoOwner, String repoName) {
        if (!this.releaseSupported) {
            return "";
        }
        Map<String, Object> props = this.props(model);
        props.put("repoOwner", repoOwner);
        props.put("repoName", repoName);
        return Templates.resolveTemplate((String)this.repoUrl, props);
    }

    public String getResolvedRepoCloneUrl(JReleaserModel model, String repoOwner, String repoName) {
        if (!this.releaseSupported) {
            return "";
        }
        Map<String, Object> props = this.props(model);
        props.put("repoOwner", repoOwner);
        props.put("repoName", repoName);
        return Templates.resolveTemplate((String)this.repoCloneUrl, props);
    }

    public String getResolvedCommitUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.commitUrl, this.props(model));
    }

    public String getResolvedSrcUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.srcUrl, this.props(model));
    }

    public String getResolvedDownloadUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.downloadUrl, this.props(model));
    }

    public String getResolvedReleaseNotesUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.releaseNotesUrl, this.props(model));
    }

    public String getResolvedLatestReleaseUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.latestReleaseUrl, this.props(model));
    }

    public String getResolvedIssueTrackerUrl(JReleaserModel model, boolean appendSlash) {
        if (!this.releaseSupported) {
            return "";
        }
        String issueTracker = Templates.resolveTemplate((String)this.issueTrackerUrl, this.props(model));
        if (appendSlash && StringUtils.isNotBlank((String)issueTracker) && !issueTracker.endsWith("/")) {
            issueTracker = issueTracker + "/";
        }
        return issueTracker;
    }

    public boolean resolveUploadAssetsEnabled(Project project) {
        if (null == this.uploadAssets) {
            this.uploadAssets = Active.ALWAYS;
        }
        this.uploadAssetsEnabled = this.uploadAssets.check((Active.Releaseable)project, (Active.Prereleaseable)this);
        return this.uploadAssetsEnabled;
    }

    public boolean isMatch() {
        return this.match;
    }

    public void setMatch(boolean match) {
        this.match = match;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabledSet() {
        return this.enabled != null;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRepoUrl() {
        return this.repoUrl;
    }

    public void setRepoUrl(String repoUrl) {
        this.repoUrl = repoUrl;
    }

    public String getRepoCloneUrl() {
        return this.repoCloneUrl;
    }

    public void setRepoCloneUrl(String repoCloneUrl) {
        this.repoCloneUrl = repoCloneUrl;
    }

    public String getCommitUrl() {
        return this.commitUrl;
    }

    public void setCommitUrl(String commitUrl) {
        this.commitUrl = commitUrl;
    }

    public String getSrcUrl() {
        return this.srcUrl;
    }

    public void setSrcUrl(String srcUrl) {
        this.srcUrl = srcUrl;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public String getReleaseNotesUrl() {
        return this.releaseNotesUrl;
    }

    public void setReleaseNotesUrl(String releaseNotesUrl) {
        this.releaseNotesUrl = releaseNotesUrl;
    }

    public String getLatestReleaseUrl() {
        return this.latestReleaseUrl;
    }

    public void setLatestReleaseUrl(String latestReleaseUrl) {
        this.latestReleaseUrl = latestReleaseUrl;
    }

    public String getIssueTrackerUrl() {
        return this.issueTrackerUrl;
    }

    public void setIssueTrackerUrl(String issueTrackerUrl) {
        this.issueTrackerUrl = issueTrackerUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public String getPreviousTagName() {
        return this.previousTagName;
    }

    public void setPreviousTagName(String previousTagName) {
        this.previousTagName = previousTagName;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public void setReleaseName(String releaseName) {
        this.releaseName = releaseName;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    @Override
    public CommitAuthor getCommitAuthor() {
        return this.commitAuthor;
    }

    @Override
    public void setCommitAuthor(CommitAuthor commitAuthor) {
        this.commitAuthor.merge(commitAuthor);
    }

    public Prerelease getPrerelease() {
        return this.prerelease;
    }

    public void setPrerelease(Prerelease prerelease) {
        this.prerelease.merge(prerelease);
    }

    public boolean isSign() {
        return this.sign != null && this.sign != false;
    }

    public void setSign(Boolean sign) {
        this.sign = sign;
    }

    public Changelog getChangelog() {
        return this.changelog;
    }

    public void setChangelog(Changelog changelog) {
        this.changelog.merge(changelog);
    }

    public Milestone getMilestone() {
        return this.milestone;
    }

    public void setMilestone(Milestone milestone) {
        this.milestone.merge(milestone);
    }

    public Issues getIssues() {
        return this.issues;
    }

    public void setIssues(Issues issues) {
        this.issues.merge(issues);
    }

    public boolean isSkipTag() {
        return this.skipTag != null && this.skipTag != false;
    }

    public void setSkipTag(Boolean skipTag) {
        this.skipTag = skipTag;
    }

    public boolean isSkipTagSet() {
        return this.skipTag != null;
    }

    public boolean isSkipRelease() {
        return this.skipRelease != null && this.skipRelease != false;
    }

    public void setSkipRelease(Boolean skipRelease) {
        this.skipRelease = skipRelease;
    }

    public boolean isSkipReleaseSet() {
        return this.skipRelease != null;
    }

    public boolean isOverwrite() {
        return this.overwrite != null && this.overwrite != false;
    }

    public void setOverwrite(Boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isOverwriteSet() {
        return this.overwrite != null;
    }

    public Update getUpdate() {
        return this.update;
    }

    public void setUpdate(Update update) {
        this.update.merge(update);
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public void setApiEndpoint(String apiEndpoint) {
        this.apiEndpoint = apiEndpoint;
    }

    @Override
    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isArtifactsSet() {
        return this.artifacts != null;
    }

    public boolean isArtifacts() {
        return this.artifacts == null || this.artifacts != false;
    }

    public void setArtifacts(Boolean artifacts) {
        this.artifacts = artifacts;
    }

    public boolean isFiles() {
        return this.files == null || this.files != false;
    }

    public void setFiles(Boolean files) {
        this.files = files;
    }

    public boolean isFilesSet() {
        return this.files != null;
    }

    public boolean isChecksumsSet() {
        return this.checksums != null;
    }

    public boolean isChecksums() {
        return this.checksums == null || this.checksums != false;
    }

    public void setChecksums(Boolean checksums) {
        this.checksums = checksums;
    }

    public boolean isSignaturesSet() {
        return this.signatures != null;
    }

    public boolean isSignatures() {
        return this.signatures == null || this.signatures != false;
    }

    public void setSignatures(Boolean signatures) {
        this.signatures = signatures;
    }

    public Active getUploadAssets() {
        return this.uploadAssets;
    }

    public void setUploadAssets(Active uploadAssets) {
        this.uploadAssets = uploadAssets;
    }

    public void setUploadAssets(String str) {
        this.setUploadAssets(Active.of((String)str));
    }

    public boolean isUploadAssetsSet() {
        return this.uploadAssets != null;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("host", this.host);
        props.put("owner", this.owner);
        props.put("name", this.name);
        props.put("username", this.username);
        props.put("token", StringUtils.isNotBlank((String)this.token) ? "************" : "**unset**");
        if (this.releaseSupported) {
            props.put("uploadAssets", this.uploadAssets);
            props.put("artifacts", this.isArtifacts());
            props.put("files", this.isFiles());
            props.put("checksums", this.isChecksums());
            props.put("signatures", this.isSignatures());
            props.put("repoUrl", this.repoUrl);
            props.put("repoCloneUrl", this.repoCloneUrl);
            props.put("commitUrl", this.commitUrl);
            props.put("srcUrl", this.srcUrl);
            props.put("downloadUrl", this.downloadUrl);
            props.put("releaseNotesUrl", this.releaseNotesUrl);
            props.put("latestReleaseUrl", this.latestReleaseUrl);
            props.put("issueTrackerUrl", this.issueTrackerUrl);
        }
        props.put("tagName", this.tagName);
        if (this.releaseSupported) {
            props.put("releaseName", this.releaseName);
        }
        props.put("branch", this.branch);
        props.put("commitAuthor", this.commitAuthor.asMap(full));
        props.put("sign", this.isSign());
        props.put("skipTag", this.isSkipTag());
        props.put("skipRelease", this.isSkipRelease());
        props.put("overwrite", this.isOverwrite());
        if (this.releaseSupported) {
            props.put("update", this.update.asMap(full));
            props.put("apiEndpoint", this.apiEndpoint);
            props.put("connectTimeout", this.connectTimeout);
            props.put("readTimeout", this.readTimeout);
        }
        props.put("changelog", this.changelog.asMap(full));
        if (this.releaseSupported) {
            props.put("milestone", this.milestone.asMap(full));
            props.put("issues", this.issues.asMap(full));
        }
        props.put("prerelease", this.prerelease.asMap(full));
        return props;
    }

    public Map<String, Object> props(JReleaserModel model) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        Project project = model.getProject();
        props.putAll(model.getEnvironment().getProperties());
        props.putAll(model.getEnvironment().getSourcedProperties());
        props.put("projectName", project.getName());
        props.put("projectNameCapitalized", StringUtils.getCapitalizedName((String)project.getName()));
        props.put("projectVersion", project.getVersion());
        props.put("projectStereotype", project.getStereotype());
        props.put("projectEffectiveVersion", project.getEffectiveVersion());
        props.put("projectSnapshot", String.valueOf(project.isSnapshot()));
        if (StringUtils.isNotBlank((String)project.getDescription())) {
            props.put("projectDescription", MustacheUtils.passThrough((String)project.getDescription()));
        }
        if (StringUtils.isNotBlank((String)project.getLongDescription())) {
            props.put("projectLongDescription", MustacheUtils.passThrough((String)project.getLongDescription()));
        }
        if (StringUtils.isNotBlank((String)project.getLicense())) {
            props.put("projectLicense", project.getLicense());
        }
        if (null != project.getInceptionYear()) {
            props.put("projectInceptionYear", project.getInceptionYear());
        }
        if (StringUtils.isNotBlank((String)project.getCopyright())) {
            props.put("projectCopyright", project.getCopyright());
        }
        if (StringUtils.isNotBlank((String)project.getVendor())) {
            props.put("projectVendor", project.getVendor());
        }
        project.getLinks().fillProps(props);
        if (project.getJava().isEnabled()) {
            props.putAll(project.getJava().getResolvedExtraProperties());
            props.put("projectJavaGroupId", project.getJava().getGroupId());
            props.put("projectJavaArtifactId", project.getJava().getArtifactId());
            String javaVersion = project.getJava().getVersion();
            props.put("projectJavaVersion", javaVersion);
            props.put("projectJavaMainClass", project.getJava().getMainClass());
            if (StringUtils.isNotBlank((String)javaVersion)) {
                SemanticVersion jv = SemanticVersion.of((String)javaVersion);
                props.put("projectJavaVersionMajor", jv.getMajor());
                if (jv.hasMinor()) {
                    props.put("projectJavaVersionMinor", jv.getMinor());
                }
                if (jv.hasPatch()) {
                    props.put("projectJavaVersionPatch", jv.getPatch());
                }
                if (jv.hasTag()) {
                    props.put("projectJavaVersionTag", jv.getTag());
                }
                if (jv.hasBuild()) {
                    props.put("projectJavaVersionBuild", jv.getBuild());
                }
            }
        }
        project.parseVersion();
        props.putAll(project.getResolvedExtraProperties());
        String osName = PlatformUtils.getDetectedOs();
        String osArch = PlatformUtils.getDetectedArch();
        props.put("osName", osName);
        props.put("osArch", osArch);
        props.put("osVersion", PlatformUtils.getDetectedVersion());
        props.put("osPlatform", PlatformUtils.getCurrentFull());
        props.put("osPlatformReplaced", model.getPlatform().applyReplacements(PlatformUtils.getCurrentFull()));
        props.put("repoHost", this.host);
        props.put("repoOwner", this.owner);
        props.put("repoName", this.name);
        props.put("repoBranch", this.branch);
        props.put("reverseRepoHost", this.getReverseRepoHost());
        props.put("repoCanonicalName", this.getCanonicalRepoName());
        props.put("tagName", project.isSnapshot() ? project.getSnapshot().getResolvedLabel(model) : this.cachedTagName);
        props.put("releaseName", this.cachedReleaseName);
        props.put("milestoneName", this.milestone.getEffectiveName());
        MustacheUtils.applyTemplates(props, project.getResolvedExtraProperties());
        props.put("__ZonedDateTime_now__", model.getNow());
        return props;
    }

    public void fillProps(Map<String, Object> props, JReleaserModel model) {
        props.put("repoHost", this.host);
        props.put("repoOwner", this.owner);
        props.put("repoName", this.name);
        props.put("repoBranch", this.branch);
        props.put("reverseRepoHost", this.getReverseRepoHost());
        props.put("repoCanonicalName", this.getCanonicalRepoName());
        props.put("tagName", this.getEffectiveTagName(model));
        props.put("releaseName", this.getEffectiveReleaseName());
        props.put("milestoneName", this.milestone.getEffectiveName());
        props.put("repoUrl", this.getResolvedRepoUrl(model));
        props.put("repoCloneUrl", this.getResolvedRepoCloneUrl(model));
        props.put("commitsUrl", this.getResolvedCommitUrl(model));
        props.put("srcUrl", this.getResolvedSrcUrl(model));
        props.put("releaseNotesUrl", this.getResolvedReleaseNotesUrl(model));
        props.put("latestReleaseUrl", this.getResolvedLatestReleaseUrl(model));
        props.put("issueTrackerUrl", this.getResolvedIssueTrackerUrl(model, false));
    }

    public static final class Issues
    extends AbstractModelObject<Issues>
    implements Domain,
    EnabledAware {
        private final Label label = new Label();
        private Apply applyMilestone;
        private String comment;
        private Boolean enabled;
        private final Releaser.Issues immutable = new Releaser.Issues(){

            public String getComment() {
                return comment;
            }

            public Apply getApplyMilestone() {
                return applyMilestone;
            }

            public Releaser.Issues.Label getLabel() {
                return label.asImmutable();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }
        };

        public Releaser.Issues asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Issues source) {
            this.comment = this.merge(this.comment, source.comment);
            this.enabled = this.merge(this.enabled, source.enabled);
            this.applyMilestone = this.merge(this.applyMilestone, source.applyMilestone);
            this.setLabel(source.label);
        }

        @Override
        public boolean isEnabled() {
            return this.enabled != null && this.enabled != false;
        }

        @Override
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabledSet() {
            return this.enabled != null;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public Label getLabel() {
            return this.label;
        }

        public void setLabel(Label label) {
            this.label.merge(label);
        }

        public Apply getApplyMilestone() {
            return this.applyMilestone;
        }

        public void setApplyMilestone(Apply applyMilestone) {
            this.applyMilestone = applyMilestone;
        }

        public void setApplyMilestone(String str) {
            this.setApplyMilestone(Apply.of((String)str));
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.isEnabled());
            map.put("comment", this.comment);
            map.put("label", this.label.asMap(full));
            map.put("applyMilestone", this.applyMilestone);
            return map;
        }

        public static final class Label
        extends AbstractModelObject<Label>
        implements Domain {
            private String name;
            private String color;
            private String description;
            private final Releaser.Issues.Label immutable = new Releaser.Issues.Label(){

                public String getName() {
                    return name;
                }

                public String getColor() {
                    return color;
                }

                public String getDescription() {
                    return description;
                }

                public Map<String, Object> asMap(boolean full) {
                    return Collections.unmodifiableMap(this.asMap(full));
                }
            };

            public Releaser.Issues.Label asImmutable() {
                return this.immutable;
            }

            @Override
            public void merge(Label source) {
                this.name = this.merge(this.name, source.name);
                this.color = this.merge(this.color, source.color);
                this.description = this.merge(this.description, source.description);
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getColor() {
                return this.color;
            }

            public void setColor(String color) {
                this.color = color;
            }

            public String getDescription() {
                return this.description;
            }

            public void setDescription(String description) {
                this.description = description;
            }

            @Override
            public Map<String, Object> asMap(boolean full) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("name", this.name);
                map.put("color", this.color);
                map.put("description", this.description);
                return map;
            }
        }
    }

    public static final class Milestone
    extends AbstractModelObject<Milestone>
    implements Domain {
        private Boolean close;
        private String name;
        private final Releaser.Milestone immutable = new Releaser.Milestone(){

            public boolean isClose() {
                return this.isClose();
            }

            public String getName() {
                return name;
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };
        @JsonIgnore
        private String cachedName;

        public Releaser.Milestone asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Milestone source) {
            this.close = this.merge(this.close, source.close);
            this.name = this.merge(this.name, source.name);
        }

        public String getConfiguredName() {
            return Env.env((String)"MILESTONE_NAME", (String)this.cachedName);
        }

        public String getResolvedName(Map<String, Object> props) {
            if (StringUtils.isBlank((String)this.cachedName)) {
                this.cachedName = this.getConfiguredName();
            }
            if (StringUtils.isBlank((String)this.cachedName)) {
                this.cachedName = Templates.resolveTemplate((String)this.name, props);
            } else if (this.cachedName.contains("{{")) {
                this.cachedName = Templates.resolveTemplate((String)this.cachedName, props);
            }
            return this.cachedName;
        }

        public String getEffectiveName() {
            return this.cachedName;
        }

        public boolean isClose() {
            return this.close == null || this.close != false;
        }

        public void setClose(Boolean close) {
            this.close = close;
        }

        public boolean isCloseSet() {
            return this.close != null;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("name", this.name);
            map.put("close", this.isClose());
            return map;
        }
    }

    public static final class Prerelease
    extends AbstractModelObject<Prerelease>
    implements Domain,
    EnabledAware {
        private Boolean enabled;
        private String pattern;
        private final Releaser.Prerelease immutable = new Releaser.Prerelease(){

            public boolean isPrerelease(String version) {
                return this.isPrerelease(version);
            }

            public String getPattern() {
                return pattern;
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }
        };

        public Releaser.Prerelease asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Prerelease source) {
            this.enabled = this.merge(this.enabled, source.enabled);
            this.pattern = this.merge(this.pattern, source.pattern);
        }

        public void disable() {
            this.enabled = false;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled != null && this.enabled != false;
        }

        @Override
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabledSet() {
            return this.enabled != null;
        }

        public boolean isPrerelease(String version) {
            if (null == this.enabled) {
                String configuredPattern = this.getConfiguredPattern();
                this.enabled = StringUtils.isNotBlank((String)configuredPattern) ? Boolean.valueOf(version.matches(configuredPattern)) : Boolean.valueOf(false);
            }
            return this.enabled;
        }

        public String getConfiguredPattern() {
            return Env.env((String)"PRERELEASE_PATTERN", (String)this.pattern);
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.isEnabled());
            map.put("pattern", this.getConfiguredPattern());
            return map;
        }
    }

    public static final class Update
    extends AbstractModelObject<Update>
    implements Domain,
    EnabledAware {
        private final Set<UpdateSection> sections = new LinkedHashSet<UpdateSection>();
        private Boolean enabled;
        private final Releaser.Update immutable = new Releaser.Update(){

            public Set<UpdateSection> getSections() {
                return Collections.unmodifiableSet(sections);
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }
        };

        public Releaser.Update asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Update source) {
            this.enabled = this.merge(this.enabled, source.enabled);
            this.setSections(this.merge(this.sections, source.sections));
        }

        @Override
        public boolean isEnabled() {
            return this.enabled != null && this.enabled != false;
        }

        @Override
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabledSet() {
            return this.enabled != null;
        }

        public Set<UpdateSection> getSections() {
            return this.sections;
        }

        public void setSections(Set<UpdateSection> sections) {
            this.sections.clear();
            this.sections.addAll(sections);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.isEnabled());
            map.put("sections", this.sections);
            return map;
        }
    }
}

