/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import org.jreleaser.cli.AbstractPlatformAwareModelCommand;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.workflow.Workflows;
import picocli.CommandLine;

@CommandLine.Command(name="full-release")
public class FullRelease
extends AbstractPlatformAwareModelCommand {
    @CommandLine.Option(names={"--dry-run"})
    Boolean dryrun;
    @CommandLine.ArgGroup
    Composite composite;

    @Override
    protected void doExecute(JReleaserContext context) {
        if (null != this.composite) {
            context.setIncludedDeployerTypes(this.collectEntries(this.composite.includedDeployerTypes(), true));
            context.setIncludedDeployerNames(this.collectEntries(this.composite.includedDeployerNames()));
            context.setIncludedUploaderTypes(this.collectEntries(this.composite.includedUploaderTypes(), true));
            context.setIncludedUploaderNames(this.collectEntries(this.composite.includedUploaderNames()));
            context.setIncludedDistributions(this.collectEntries(this.composite.includedDistributions()));
            context.setIncludedPackagers(this.collectEntries(this.composite.includedPackagers(), true));
            context.setIncludedAnnouncers(this.collectEntries(this.composite.includedAnnouncers(), true));
            context.setExcludedDeployerTypes(this.collectEntries(this.composite.excludedDeployerTypes(), true));
            context.setExcludedDeployerNames(this.collectEntries(this.composite.excludedDeployerNames()));
            context.setExcludedUploaderTypes(this.collectEntries(this.composite.excludedUploaderTypes(), true));
            context.setExcludedUploaderNames(this.collectEntries(this.composite.excludedUploaderNames()));
            context.setExcludedDistributions(this.collectEntries(this.composite.excludedDistributions()));
            context.setExcludedPackagers(this.collectEntries(this.composite.excludedPackagers(), true));
            context.setExcludedAnnouncers(this.collectEntries(this.composite.excludedAnnouncers(), true));
        }
        Workflows.fullRelease((JReleaserContext)context).execute();
    }

    @Override
    protected Boolean dryrun() {
        return this.dryrun;
    }

    static class Exclude {
        @CommandLine.Option(names={"-xy", "--exclude-deployer"}, paramLabel="<deployer>")
        String[] excludedDeployerTypes;
        @CommandLine.Option(names={"-xyn", "--exclude-deployer-name"}, paramLabel="<name>")
        String[] excludedDeployerNames;
        @CommandLine.Option(names={"-xu", "--exclude-uploader"}, paramLabel="<uploader>")
        String[] excludedUploaderTypes;
        @CommandLine.Option(names={"-xun", "--exclude-uploader-name"}, paramLabel="<name>")
        String[] excludedUploaderNames;
        @CommandLine.Option(names={"-xd", "--exclude-distribution"}, paramLabel="<distribution>")
        String[] excludedDistributions;
        @CommandLine.Option(names={"-xp", "--exclude-packager"}, paramLabel="<packager>")
        String[] excludedPackagers;
        @CommandLine.Option(names={"-xa", "--exclude-announcer"}, paramLabel="<announcer>")
        String[] excludedAnnouncers;

        Exclude() {
        }
    }

    static class Include {
        @CommandLine.Option(names={"-y", "--deployer"}, paramLabel="<deployer>")
        String[] includedDeployerTypes;
        @CommandLine.Option(names={"-yn", "--deployer-name"}, paramLabel="<name>")
        String[] includedDeployerNames;
        @CommandLine.Option(names={"-u", "--uploader"}, paramLabel="<uploader>")
        String[] includedUploaderTypes;
        @CommandLine.Option(names={"-un", "--uploader-name"}, paramLabel="<name>")
        String[] includedUploaderNames;
        @CommandLine.Option(names={"-d", "--distribution"}, paramLabel="<distribution>")
        String[] includedDistributions;
        @CommandLine.Option(names={"-p", "--packager"}, paramLabel="<packager>")
        String[] includedPackagers;
        @CommandLine.Option(names={"-a", "--announcer"}, paramLabel="<announcer>")
        String[] includedAnnouncers;

        Include() {
        }
    }

    static class Composite {
        @CommandLine.ArgGroup(exclusive=false, order=1, headingKey="include.filter.header")
        Include include;
        @CommandLine.ArgGroup(exclusive=false, order=2, headingKey="exclude.filter.header")
        Exclude exclude;

        Composite() {
        }

        String[] includedDeployerTypes() {
            return this.include != null ? this.include.includedDeployerTypes : null;
        }

        String[] includedDeployerNames() {
            return this.include != null ? this.include.includedDeployerNames : null;
        }

        String[] includedUploaderTypes() {
            return this.include != null ? this.include.includedUploaderTypes : null;
        }

        String[] includedUploaderNames() {
            return this.include != null ? this.include.includedUploaderNames : null;
        }

        String[] includedDistributions() {
            return this.include != null ? this.include.includedDistributions : null;
        }

        String[] includedPackagers() {
            return this.include != null ? this.include.includedPackagers : null;
        }

        String[] includedAnnouncers() {
            return this.include != null ? this.include.includedAnnouncers : null;
        }

        String[] excludedDeployerTypes() {
            return this.exclude != null ? this.exclude.excludedDeployerTypes : null;
        }

        String[] excludedDeployerNames() {
            return this.exclude != null ? this.exclude.excludedDeployerNames : null;
        }

        String[] excludedUploaderTypes() {
            return this.exclude != null ? this.exclude.excludedUploaderTypes : null;
        }

        String[] excludedUploaderNames() {
            return this.exclude != null ? this.exclude.excludedUploaderNames : null;
        }

        String[] excludedDistributions() {
            return this.exclude != null ? this.exclude.excludedDistributions : null;
        }

        String[] excludedPackagers() {
            return this.exclude != null ? this.exclude.excludedPackagers : null;
        }

        String[] excludedAnnouncers() {
            return this.exclude != null ? this.exclude.excludedAnnouncers : null;
        }
    }
}

