/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.GroupGrantee;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.Permission;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;
import org.apache.tika.Tika;
import org.apache.tika.mime.MediaType;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.upload.S3Uploader;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.spi.upload.UploadException;
import org.jreleaser.sdk.commons.AbstractArtifactUploader;
import org.jreleaser.util.StringUtils;

public class S3ArtifactUploader
extends AbstractArtifactUploader<S3Uploader, org.jreleaser.model.internal.upload.S3Uploader> {
    private static final Tika TIKA = new Tika();
    private org.jreleaser.model.internal.upload.S3Uploader uploader;

    public S3ArtifactUploader(JReleaserContext context) {
        super(context);
    }

    public org.jreleaser.model.internal.upload.S3Uploader getUploader() {
        return this.uploader;
    }

    public void setUploader(org.jreleaser.model.internal.upload.S3Uploader uploader) {
        this.uploader = uploader;
    }

    public String getType() {
        return "s3";
    }

    public void upload(String name) throws UploadException {
        List artifacts = this.collectArtifacts();
        if (artifacts.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"artifacts.no.match", (Object[])new Object[0]));
        }
        String bucketName = this.uploader.getBucket();
        AmazonS3 s3 = this.createS3Client();
        this.context.getLogger().debug(RB.$((String)"s3.bucket.check", (Object[])new Object[0]), new Object[]{bucketName});
        if (!this.context.isDryrun() && !s3.doesBucketExistV2(bucketName)) {
            this.context.getLogger().debug(RB.$((String)"s3.bucket.create", (Object[])new Object[0]), new Object[]{bucketName});
            s3.createBucket(bucketName);
        }
        for (Artifact artifact : artifacts) {
            Path path = artifact.getEffectivePath(this.context);
            this.context.getLogger().info(" - {}", new Object[]{path.getFileName()});
            try {
                String bucketPath = this.uploader.getResolvedPath(this.context, artifact);
                this.context.getLogger().debug("   {}", new Object[]{bucketPath});
                if (this.context.isDryrun()) continue;
                this.context.getLogger().debug(RB.$((String)"s3.object.check", (Object[])new Object[0]), new Object[]{bucketName, bucketPath});
                if (s3.doesObjectExist(bucketName, bucketPath)) {
                    this.context.getLogger().debug(RB.$((String)"s3.object.create", (Object[])new Object[0]), new Object[]{bucketName, bucketPath});
                    s3.deleteObject(bucketName, bucketPath);
                }
                ObjectMetadata meta = new ObjectMetadata();
                meta.setContentType(MediaType.parse((String)TIKA.detect(path)).toString());
                meta.setContentLength(Files.size(path));
                this.context.getLogger().debug(RB.$((String)"s3.object.write", (Object[])new Object[0]), new Object[]{bucketName, bucketPath});
                try (InputStream is = Files.newInputStream(path, StandardOpenOption.READ);){
                    s3.putObject(new PutObjectRequest(bucketName, bucketPath, is, meta));
                }
                this.context.getLogger().debug(RB.$((String)"s3.object.acl", (Object[])new Object[0]), new Object[]{bucketName, bucketPath});
                AccessControlList acl = s3.getObjectAcl(bucketName, bucketPath);
                acl.grantPermission((Grantee)GroupGrantee.AllUsers, Permission.Read);
                s3.setObjectAcl(bucketName, bucketPath, acl);
            }
            catch (IOException e) {
                this.context.getLogger().trace((Throwable)e);
                throw new UploadException(RB.$((String)"ERROR_unexpected_upload", (Object[])new Object[]{this.context.relativizeToBasedir(path)}), (Throwable)e);
            }
        }
    }

    private AmazonS3 createS3Client() throws UploadException {
        try {
            AmazonS3ClientBuilder s3Builder = AmazonS3ClientBuilder.standard();
            if (StringUtils.isNotBlank((String)this.uploader.getAccessKeyId()) && StringUtils.isNotBlank((String)this.uploader.getSecretKey()) && StringUtils.isNotBlank((String)this.uploader.getSessionToken())) {
                s3Builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicSessionCredentials(this.uploader.getAccessKeyId(), this.uploader.getSecretKey(), this.uploader.getSessionToken())));
            } else if (StringUtils.isNotBlank((String)this.uploader.getAccessKeyId()) && StringUtils.isNotBlank((String)this.uploader.getSecretKey())) {
                s3Builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.uploader.getAccessKeyId(), this.uploader.getSecretKey())));
            }
            Map headers = this.uploader.getHeaders();
            if (headers != null) {
                ClientConfiguration clientConfiguration = new ClientConfiguration();
                for (Map.Entry header : headers.entrySet()) {
                    if (header.getKey() == null || header.getValue() == null) continue;
                    clientConfiguration.addHeader((String)header.getKey(), (String)header.getValue());
                }
                s3Builder.setClientConfiguration(clientConfiguration);
            }
            if (StringUtils.isBlank((String)this.uploader.getEndpoint())) {
                s3Builder.withRegion(this.uploader.getRegion());
            } else {
                s3Builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.uploader.getEndpoint(), this.uploader.getRegion()));
            }
            s3Builder.getClientConfiguration().setConnectionTimeout(this.uploader.getConnectTimeout() * 1000);
            return (AmazonS3)s3Builder.build();
        }
        catch (SdkClientException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new UploadException(RB.$((String)"ERROR_unexpected_s3_client_config", (Object[])new Object[0]), (Throwable)e);
        }
    }
}

