/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.context;

import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.api.JReleaserModel;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.release.CodebergReleaser;
import org.jreleaser.model.internal.release.GithubReleaser;
import org.jreleaser.model.internal.release.GitlabReleaser;
import org.jreleaser.model.spi.release.Commit;
import org.jreleaser.model.spi.release.Repository;
import org.jreleaser.sdk.git.GitSdk;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public class ModelConfigurer {
    public static void configure(JReleaserContext context) {
        try {
            Commit head = GitSdk.of((JReleaserContext)context).head();
            context.getModel().setCommit(new JReleaserModel.Commit(head.getShortHash(), head.getFullHash(), head.getRefName(), head.getCommitTime(), head.getTimestamp()));
        }
        catch (Exception e) {
            if (context.getMode() == JReleaserContext.Mode.ASSEMBLE || context.getMode() == JReleaserContext.Mode.DEPLOY || context.getMode() == JReleaserContext.Mode.DOWNLOAD) {
                return;
            }
            context.getLogger().trace((Throwable)e);
            throw new JReleaserException(RB.$((String)"ERROR_context_configurer_fail_git_head", (Object[])new Object[0]), (Throwable)e);
        }
        Repository repository = null;
        try {
            repository = GitSdk.of((JReleaserContext)context).getRemote();
        }
        catch (Exception e) {
            context.getLogger().trace((Throwable)e);
            throw new JReleaserException(RB.$((String)"ERROR_context_configurer_fail_git_remote", (Object[])new Object[0]), (Throwable)e);
        }
        if (StringUtils.isBlank((String)context.getModel().getProject().getResolvedName())) {
            context.getModel().getProject().setName(repository.getName());
        }
        switch (repository.getKind()) {
            case GITHUB: {
                ModelConfigurer.autoConfigureGithub(context, repository);
                break;
            }
            case GITLAB: {
                ModelConfigurer.autoConfigureGitlab(context, repository);
                break;
            }
            case CODEBERG: {
                ModelConfigurer.autoConfigureCodeberg(context, repository);
                break;
            }
            default: {
                ModelConfigurer.autoConfigureOther(context, repository);
            }
        }
    }

    private static void autoConfigureGithub(JReleaserContext context, Repository repository) {
        BaseReleaser service = context.getModel().getRelease().getReleaser();
        if (service != null) {
            if (!(service instanceof GithubReleaser)) {
                context.getModel().getRelease().getReleaser().setMatch(false);
                context.getModel().getRelease().getReleaser().setSkipTag(Boolean.valueOf(true));
                context.getLogger().warn(RB.$((String)"ERROR_context_configurer_detected_git", (Object[])new Object[0]), new Object[]{"github", service.getServiceName()});
            }
        } else {
            context.getModel().getRelease().setGithub(new GithubReleaser());
        }
        ModelConfigurer.fillGitProperties(context.getLogger(), context.getModel().getRelease().getReleaser(), repository, context.getModel().getCommit());
    }

    private static void autoConfigureGitlab(JReleaserContext context, Repository repository) {
        BaseReleaser service = context.getModel().getRelease().getReleaser();
        if (service != null) {
            if (!(service instanceof GitlabReleaser)) {
                context.getModel().getRelease().getReleaser().setMatch(false);
                context.getModel().getRelease().getReleaser().setSkipTag(Boolean.valueOf(true));
                context.getLogger().warn(RB.$((String)"ERROR_context_configurer_detected_git", (Object[])new Object[0]), new Object[]{"gitlab", service.getServiceName()});
            }
        } else {
            context.getModel().getRelease().setGitlab(new GitlabReleaser());
        }
        ModelConfigurer.fillGitProperties(context.getLogger(), context.getModel().getRelease().getReleaser(), repository, context.getModel().getCommit());
    }

    private static void autoConfigureCodeberg(JReleaserContext context, Repository repository) {
        BaseReleaser service = context.getModel().getRelease().getReleaser();
        if (service != null) {
            if (!(service instanceof CodebergReleaser)) {
                context.getModel().getRelease().getReleaser().setMatch(false);
                context.getModel().getRelease().getReleaser().setSkipTag(Boolean.valueOf(true));
                context.getLogger().warn(RB.$((String)"ERROR_context_configurer_detected_git", (Object[])new Object[0]), new Object[]{"codeberg", service.getServiceName()});
            }
        } else {
            context.getModel().getRelease().setCodeberg(new CodebergReleaser());
        }
        ModelConfigurer.fillGitProperties(context.getLogger(), context.getModel().getRelease().getReleaser(), repository, context.getModel().getCommit());
    }

    private static void autoConfigureOther(JReleaserContext context, Repository repository) {
        BaseReleaser service = context.getModel().getRelease().getReleaser();
        if (service != null) {
            ModelConfigurer.fillGitProperties(context.getLogger(), service, repository, context.getModel().getCommit());
        }
    }

    private static void fillGitProperties(JReleaserLogger logger, BaseReleaser service, Repository repository, JReleaserModel.Commit head) {
        if (StringUtils.isBlank((String)service.getOwner())) {
            service.setOwner(repository.getOwner());
        }
        if (!service.getOwner().equals(repository.getOwner())) {
            service.setMatch(false);
            service.setSkipTag(Boolean.valueOf(true));
            logger.warn(RB.$((String)"ERROR_context_configurer_detected_git_owner", (Object[])new Object[0]), new Object[]{repository.getOwner(), service.getOwner()});
        }
        if (StringUtils.isBlank((String)service.getName())) {
            service.setName(repository.getName());
        }
        if (!service.getName().equals(repository.getName())) {
            service.setMatch(false);
            service.setSkipTag(Boolean.valueOf(true));
            logger.warn(RB.$((String)"ERROR_context_configurer_detected_git_name", (Object[])new Object[0]), new Object[]{repository.getName(), service.getName()});
        }
        service.setBranch(Env.env((String)"BRANCH", (String)service.getBranch()));
        if (StringUtils.isBlank((String)service.getBranch())) {
            service.setBranch(head.getRefName());
        }
        if (!service.getBranch().equals(head.getRefName())) {
            service.setMatch(false);
            logger.warn(RB.$((String)"ERROR_context_configurer_detected_git_branch", (Object[])new Object[0]), new Object[]{head.getRefName(), service.getBranch()});
        }
    }
}

