/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.init;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.LocalDate;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.config.JReleaserConfigParser;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.templates.TemplateResource;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.templates.VersionDecoratingWriter;

public class Init {
    public static void execute(JReleaserLogger logger, String format, boolean overwrite, Path outputDirectory) {
        try {
            if (!Init.getSupportedConfigFormats().contains(format)) {
                throw new IllegalArgumentException(RB.$((String)"jreleaser.init.ERROR_invalid_format", (Object[])new Object[]{String.join((CharSequence)"|", Init.getSupportedConfigFormats())}));
            }
            Path outputFile = outputDirectory.resolve("jreleaser." + format);
            TemplateResource template = TemplateUtils.resolveTemplate((JReleaserLogger)logger, (String)("init/jreleaser." + format + ".tpl"));
            String content = IOUtils.toString((Reader)template.getReader());
            LocalDate now = LocalDate.now();
            content = content.replaceAll("@year@", now.getYear() + "");
            logger.info(RB.$((String)"jreleaser.init.TEXT_writing_file", (Object[])new Object[0]), new Object[]{outputFile.toAbsolutePath()});
            try (BufferedWriter fileWriter = Files.newBufferedWriter(outputFile, overwrite ? StandardOpenOption.CREATE : StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                 VersionDecoratingWriter decoratedWriter = new VersionDecoratingWriter((Writer)fileWriter);){
                decoratedWriter.write(content);
            }
            catch (FileAlreadyExistsException e) {
                logger.error(RB.$((String)"jreleaser.init.ERROR_file_exists", (Object[])new Object[0]), new Object[]{outputFile.toAbsolutePath()});
                if (logger != null) {
                    logger.close();
                }
                return;
            }
            logger.info(RB.$((String)"jreleaser.init.TEXT_success", (Object[])new Object[0]), new Object[]{outputDirectory.toAbsolutePath()});
        }
        catch (IOException | IllegalStateException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
        finally {
            if (logger != null) {
                logger.close();
            }
        }
    }

    private static Set<String> getSupportedConfigFormats() {
        LinkedHashSet<String> extensions = new LinkedHashSet<String>();
        ServiceLoader<JReleaserConfigParser> parsers = ServiceLoader.load(JReleaserConfigParser.class, JReleaserConfigParser.class.getClassLoader());
        for (JReleaserConfigParser parser : parsers) {
            extensions.add(parser.getPreferredFileExtension());
        }
        return extensions;
    }
}

