/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.ChocolateyPackager;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.release.GithubReleaser;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.sdk.command.Command;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class ChocolateyPackagerProcessor
extends AbstractRepositoryPackagerProcessor<ChocolateyPackager> {
    public ChocolateyPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, TemplateContext props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(props);
        if (((ChocolateyPackager)this.packager).isRemoteBuild()) {
            return;
        }
        if (!PlatformUtils.isWindows()) {
            this.context.getLogger().warn(RB.$((String)"ERROR_packager_requires_platform", (Object[])new Object[]{"Windows"}));
            return;
        }
        this.createChocolateyPackage(distribution, props);
    }

    @Override
    protected void doPublishDistribution(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
        if (((ChocolateyPackager)this.packager).isRemoteBuild()) {
            super.doPublishDistribution(distribution, props);
            return;
        }
        if (this.context.isDryrun()) {
            this.context.getLogger().error(RB.$((String)"dryrun.set", (Object[])new Object[0]));
            return;
        }
        if (!PlatformUtils.isWindows()) {
            this.context.getLogger().warn(RB.$((String)"ERROR_packager_requires_platform", (Object[])new Object[]{"Windows"}));
            return;
        }
        this.publishChocolateyPackage(distribution, props);
    }

    @Override
    protected void fillPackagerProperties(TemplateContext props, Distribution distribution) {
        props.set("distributionJavaMainClass", (Object)distribution.getJava().getMainClass());
        props.set("distributionJavaMainModule", (Object)distribution.getJava().getMainModule());
        BaseReleaser releaser = this.context.getModel().getRelease().getReleaser();
        if (!props.contains("projectLicenseUrl") || StringUtils.isBlank((String)((String)props.get("projectLicenseUrl")))) {
            this.context.getLogger().warn(RB.$((String)"ERROR_project_no_license_url", (Object[])new Object[0]));
        }
        String repoUrl = releaser.getResolvedRepoUrl(this.context.getModel());
        String bucketRepoUrl = releaser.getResolvedRepoUrl(this.context.getModel(), ((ChocolateyPackager)this.packager).getBucket().getOwner(), ((ChocolateyPackager)this.packager).getBucket().getResolvedName());
        props.set("chocolateyPackageSourceUrl", (Object)(((ChocolateyPackager)this.packager).isRemoteBuild() ? bucketRepoUrl : repoUrl));
        props.set("chocolateyBucketRepoUrl", (Object)bucketRepoUrl);
        props.set("chocolateyBucketRepoCloneUrl", (Object)releaser.getResolvedRepoCloneUrl(this.context.getModel(), ((ChocolateyPackager)this.packager).getBucket().getOwner(), ((ChocolateyPackager)this.packager).getBucket().getResolvedName()));
        props.set("chocolateyPackageName", (Object)((ChocolateyPackager)this.packager).getPackageName());
        props.set("chocolateyPackageVersion", (Object)Templates.resolveTemplate((String)((ChocolateyPackager)this.packager).getPackageVersion(), (TemplateContext)props));
        props.set("chocolateyUsername", (Object)((ChocolateyPackager)this.packager).getUsername());
        props.set("chocolateyTitle", (Object)((ChocolateyPackager)this.packager).getTitle());
        props.set("chocolateyIconUrl", (Object)Templates.resolveTemplate((String)((ChocolateyPackager)this.packager).getIconUrl(), (TemplateContext)props));
        props.set("chocolateySource", (Object)((ChocolateyPackager)this.packager).getSource());
    }

    @Override
    protected void writeFile(Distribution distribution, String content, TemplateContext props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        BaseReleaser gitService = this.context.getModel().getRelease().getReleaser();
        if (!(!fileName.contains(".github") || ((ChocolateyPackager)this.packager).isRemoteBuild() && gitService instanceof GithubReleaser)) {
            return;
        }
        Path outputFile = "binary.nuspec".equals(fileName = TemplateUtils.trimTplExtension((String)fileName)) ? outputDirectory.resolve(distribution.getName()).resolve(((ChocolateyPackager)this.packager).getPackageName().concat(".nuspec")) : (fileName.endsWith(".ps1") ? outputDirectory.resolve(distribution.getName()).resolve(fileName) : outputDirectory.resolve(fileName));
        this.writeFile(content, outputFile);
    }

    private void createChocolateyPackage(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        Path execDirectory = packageDirectory.resolve(distribution.getName());
        Command cmd = new Command("choco").arg("pack").arg(((ChocolateyPackager)this.packager).getPackageName() + ".nuspec");
        this.context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
        this.executeCommand(execDirectory, cmd);
    }

    private void publishChocolateyPackage(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        Path execDirectory = packageDirectory.resolve(distribution.getName());
        Command cmd = new Command("choco").arg("apikey").arg("-k").arg(((ChocolateyPackager)this.packager).getApiKey()).arg("-source").arg(((ChocolateyPackager)this.packager).getSource());
        this.executeCommand(execDirectory, cmd);
        try {
            Optional nuget = (Optional)FileUtils.listFilesAndProcess((Path)execDirectory, files -> files.map(Path::getFileName).map(Path::toString).filter(s -> s.endsWith(".nupkg")).findFirst());
            if (!nuget.isPresent()) {
                throw new PackagerProcessingException(RB.$((String)"ERROR_chocolatey_nuget_not_found", (Object[])new Object[]{this.context.relativizeToBasedir(execDirectory)}));
            }
            cmd = new Command("choco").arg("push").arg((String)nuget.get()).arg("-s").arg(((ChocolateyPackager)this.packager).getSource());
            this.context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
            this.executeCommand(execDirectory, cmd);
        }
        catch (IOException e) {
            throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }
}

