/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.git.release;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jreleaser.model.Signing;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.catalog.sbom.SbomCataloger;
import org.jreleaser.model.internal.checksum.Checksum;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.signing.Signing;
import org.jreleaser.model.internal.util.Artifacts;
import org.jreleaser.model.spi.catalog.sbom.SbomCatalogerProcessorHelper;
import org.jreleaser.model.spi.release.Asset;
import org.jreleaser.model.spi.release.Releaser;
import org.jreleaser.model.spi.release.ReleaserBuilder;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.StringUtils;

public abstract class AbstractReleaserBuilder<R extends Releaser<?>>
implements ReleaserBuilder<R> {
    protected final Set<Asset> assets = new TreeSet<Asset>();
    protected JReleaserContext context;

    public ReleaserBuilder<R> addReleaseAsset(Asset asset) {
        if (null != asset) {
            this.assets.add(asset);
        }
        return this;
    }

    public ReleaserBuilder<R> addReleaseAssets(Path assets) {
        if (assets.toFile().exists()) {
            for (File asset : assets.toFile().listFiles()) {
                this.addReleaseAsset(Asset.file((Artifact)Artifact.of((Path)asset.toPath().toAbsolutePath())));
            }
        }
        return this;
    }

    public ReleaserBuilder<R> setReleaseAssets(List<Asset> assets) {
        if (null != assets) {
            this.assets.addAll(assets);
        }
        return this;
    }

    protected void validate() {
        Objects.requireNonNull(this.context, "'context' must not be null");
    }

    public ReleaserBuilder<R> configureWith(JReleaserContext context) {
        Signing signing;
        this.context = context;
        BaseReleaser service = context.getModel().getRelease().getReleaser();
        if (!service.resolveUploadAssetsEnabled(context.getModel().getProject())) {
            return this;
        }
        LinkedHashSet<Asset> assets = new LinkedHashSet<Asset>();
        Checksum checksum = context.getModel().getChecksum();
        if (service.isFiles()) {
            for (Artifact artifact : Artifacts.resolveFiles((JReleaserContext)context)) {
                if (!artifact.isActiveAndSelected() || artifact.extraPropertyIsTrue("skipRelease") || artifact.isOptional(context) && !artifact.resolvedPathExists()) continue;
                Path path = artifact.getEffectivePath(context);
                assets.add(Asset.file((Artifact)Artifact.of((Path)path, (Map)artifact.getExtraProperties())));
                if (!service.isChecksums() || !this.isIndividual(context, artifact) || artifact.extraPropertyIsTrue("skipChecksum")) continue;
                for (Algorithm algorithm : checksum.getAlgorithms()) {
                    assets.add(Asset.checksum((Artifact)Artifact.of((Path)context.getChecksumsDirectory().resolve(path.getFileName() + "." + algorithm.formatted()))));
                }
            }
        }
        if (service.isArtifacts()) {
            for (Distribution distribution : context.getModel().getActiveDistributions()) {
                if (distribution.extraPropertyIsTrue("skipRelease")) continue;
                for (Artifact artifact : distribution.getArtifacts()) {
                    if (!artifact.isActiveAndSelected() || artifact.extraPropertyIsTrue("skipRelease") || artifact.isOptional(context) && !artifact.resolvedPathExists()) continue;
                    Path path = artifact.getEffectivePath(context, distribution);
                    assets.add(Asset.file((Artifact)Artifact.of((Path)path, (Map)artifact.getExtraProperties()), (Distribution)distribution));
                    if (!service.isChecksums() || !this.isIndividual(context, distribution, artifact)) continue;
                    for (Algorithm algorithm : checksum.getAlgorithms()) {
                        assets.add(Asset.checksum((Artifact)Artifact.of((Path)context.getChecksumsDirectory().resolve(distribution.getName()).resolve(path.getFileName() + "." + algorithm.formatted()))));
                    }
                }
            }
        }
        if (service.isChecksums()) {
            for (Object algorithm : checksum.getAlgorithms()) {
                Path checksums = context.getChecksumsDirectory().resolve(checksum.getResolvedName(context, (Algorithm)algorithm));
                if (!Files.exists(checksums, new LinkOption[0])) continue;
                assets.add(Asset.checksum((Artifact)Artifact.of((Path)checksums)));
            }
        }
        if (service.isCatalogs()) {
            List catalogers = context.getModel().getCatalog().getSbom().findAllActiveSbomCatalogers();
            for (SbomCataloger cataloger : catalogers) {
                if (!cataloger.getPack().isEnabled()) continue;
                SbomCatalogerProcessorHelper.resolveArtifacts((JReleaserContext)context, (SbomCataloger)cataloger).stream().map(Asset::catalog).forEach(assets::add);
            }
        }
        if ((signing = context.getModel().getSigning()).isEnabled() && service.isSignatures()) {
            boolean signaturesAdded = false;
            ArrayList assetsCopy = new ArrayList(assets);
            for (Asset asset : assetsCopy) {
                Path signature;
                if (asset.getArtifact().extraPropertyIsTrue("skipSigning") || asset.getArtifact().extraPropertyIsTrue("skipReleaseSignatures") || !Files.exists(signature = context.getSignaturesDirectory().resolve(asset.getFilename() + signing.getSignatureExtension()), new LinkOption[0])) continue;
                assets.add(Asset.signature((Artifact)Artifact.of((Path)signature)));
                signaturesAdded = true;
            }
            if (signaturesAdded && signing.getMode() == Signing.Mode.COSIGN) {
                Path publicKeyFile = signing.getCosign().getResolvedPublicKeyFilePath(context);
                assets.add(Asset.signature((Artifact)Artifact.of((Path)publicKeyFile)));
            }
        }
        if (service.isCatalogs()) {
            SbomCatalogerProcessorHelper.resolveArtifacts((JReleaserContext)context).stream().map(Asset::catalog).forEach(assets::add);
        }
        assets.forEach(this::addReleaseAsset);
        return this;
    }

    private boolean isIndividual(JReleaserContext context, Artifact artifact) {
        if (artifact.getExtraProperties().containsKey("individualChecksum")) {
            return StringUtils.isTrue(artifact.getExtraProperties().get("individualChecksum"));
        }
        return context.getModel().getChecksum().isIndividual();
    }

    private boolean isIndividual(JReleaserContext context, Distribution distribution, Artifact artifact) {
        if (artifact.getExtraProperties().containsKey("individualChecksum")) {
            return StringUtils.isTrue(artifact.getExtraProperties().get("individualChecksum"));
        }
        if (distribution.getExtraProperties().containsKey("individualChecksum")) {
            return StringUtils.isTrue(distribution.getExtraProperties().get("individualChecksum"));
        }
        return context.getModel().getChecksum().isIndividual();
    }
}

