/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.util.Set;
import org.jreleaser.cli.AbstractCommand;
import org.jreleaser.cli.AbstractModelCommand;
import org.jreleaser.cli.Main;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.workflow.Workflows;
import picocli.CommandLine;

@CommandLine.Command(name="announce")
public class Announce
extends AbstractModelCommand<Main> {
    @CommandLine.Option(names={"--dry-run"})
    Boolean dryrun;
    @CommandLine.ArgGroup
    Composite composite;

    @Override
    protected void collectCandidateDeprecatedArgs(Set<AbstractCommand.DeprecatedArg> args) {
        super.collectCandidateDeprecatedArgs(args);
        args.add(new AbstractCommand.DeprecatedArg("-a", "--announcer", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-xa", "--exclude-announcer", "1.5.0"));
    }

    @Override
    protected void doExecute(JReleaserContext context) {
        if (null != this.composite) {
            context.setIncludedAnnouncers(this.collectEntries(this.composite.includedAnnouncers(), true));
            context.setExcludedAnnouncers(this.collectEntries(this.composite.excludedAnnouncers(), true));
        }
        Workflows.announce((JReleaserContext)context).execute();
    }

    @Override
    protected Boolean dryrun() {
        return this.dryrun;
    }

    @Override
    protected JReleaserContext.Mode getMode() {
        return JReleaserContext.Mode.ANNOUNCE;
    }

    static class Exclude {
        @CommandLine.Option(names={"-xa", "--exclude-announcer"}, paramLabel="<announcer>")
        String[] excludedAnnouncers;

        Exclude() {
        }
    }

    static class Include {
        @CommandLine.Option(names={"-a", "--announcer"}, paramLabel="<announcer>")
        String[] includedAnnouncers;

        Include() {
        }
    }

    static class Composite {
        @CommandLine.ArgGroup(exclusive=false, order=1, headingKey="include.filter.header")
        Include include;
        @CommandLine.ArgGroup(exclusive=false, order=2, headingKey="exclude.filter.header")
        Exclude exclude;

        Composite() {
        }

        String[] includedAnnouncers() {
            return null != this.include ? this.include.includedAnnouncers : null;
        }

        String[] excludedAnnouncers() {
            return null != this.exclude ? this.exclude.excludedAnnouncers : null;
        }
    }
}

